/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.link;

import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aConfirmationOfFundsResponse;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.link.BaseAspectService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.controller.ConsentController;
import de.adorsys.psd2.xs2a.web.link.CreateAisAuthorisationLinks;
import de.adorsys.psd2.xs2a.web.link.CreateConsentLinks;
import de.adorsys.psd2.xs2a.web.link.CreatePiisConsentLinks;
import de.adorsys.psd2.xs2a.web.link.UpdateConsentLinks;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsentAspectService
extends BaseAspectService<ConsentController> {
    private ScaApproachResolver scaApproachResolver;
    private AuthorisationMethodDecider authorisationMethodDecider;
    private RedirectLinkBuilder redirectLinkBuilder;
    private RedirectIdService redirectIdService;
    private RequestProviderService requestProviderService;

    @Autowired
    public ConsentAspectService(ScaApproachResolver scaApproachResolver, AuthorisationMethodDecider authorisationMethodDecider, RedirectLinkBuilder redirectLinkBuilder, AspspProfileServiceWrapper aspspProfileServiceWrapper, RedirectIdService redirectIdService, RequestProviderService requestProviderService) {
        super(aspspProfileServiceWrapper);
        this.scaApproachResolver = scaApproachResolver;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.redirectLinkBuilder = redirectLinkBuilder;
        this.redirectIdService = redirectIdService;
        this.requestProviderService = requestProviderService;
    }

    public ResponseObject<CreateConsentResponse> invokeCreateAccountConsentAspect(ResponseObject<CreateConsentResponse> result, boolean explicitPreferred) {
        if (!result.hasError()) {
            CreateConsentResponse body = result.getBody();
            boolean explicitMethod = this.authorisationMethodDecider.isExplicitMethod(explicitPreferred, body.isMultilevelScaRequired());
            boolean signingBasketModeActive = this.authorisationMethodDecider.isSigningBasketModeActive(explicitPreferred);
            body.setLinks(new CreateConsentLinks(this.getHttpUrl(), this.scaApproachResolver, body, this.redirectLinkBuilder, this.redirectIdService, explicitMethod, signingBasketModeActive, this.getScaRedirectFlow(), this.isAuthorisationConfirmationRequestMandated(), this.requestProviderService.getInstanceId()));
        }
        return result;
    }

    public ResponseObject<AuthorisationResponse> invokeCreateConsentPsuDataAspect(ResponseObject<AuthorisationResponse> result) {
        if (!result.hasError()) {
            if (result.getBody() instanceof UpdateConsentPsuDataResponse) {
                UpdateConsentPsuDataResponse body = (UpdateConsentPsuDataResponse)result.getBody();
                body.setLinks(this.buildLinksForUpdateConsentResponse(body));
            } else if (result.getBody() instanceof CreateConsentAuthorizationResponse) {
                CreateConsentAuthorizationResponse body = (CreateConsentAuthorizationResponse)result.getBody();
                body.setLinks(new CreateAisAuthorisationLinks(this.getHttpUrl(), body, this.scaApproachResolver, this.redirectLinkBuilder, this.redirectIdService, this.getScaRedirectFlow(), this.isAuthorisationConfirmationRequestMandated(), this.requestProviderService.getInstanceId()));
            }
        }
        return result;
    }

    public ResponseObject<UpdateConsentPsuDataResponse> invokeUpdateConsentPsuDataAspect(ResponseObject<UpdateConsentPsuDataResponse> result) {
        if (!result.hasError()) {
            UpdateConsentPsuDataResponse body = result.getBody();
            body.setLinks(this.buildLinksForUpdateConsentResponse(body));
        }
        return result;
    }

    private Links buildLinksForUpdateConsentResponse(UpdateConsentPsuDataResponse response) {
        return Optional.ofNullable(response.getScaStatus()).map(status -> new UpdateConsentLinks(this.getHttpUrl(), this.scaApproachResolver, response)).orElse(null);
    }

    public ResponseObject<Xs2aConfirmationOfFundsResponse> createPiisConsentWithResponse(ResponseObject<Xs2aConfirmationOfFundsResponse> result, boolean explicitPreferred) {
        if (!result.hasError()) {
            Xs2aConfirmationOfFundsResponse body = result.getBody();
            body.setLinks(new CreatePiisConsentLinks(this.getHttpUrl(), body));
        }
        return result;
    }
}

