/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.piis.v2;

import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.model.ConsentsConfirmationOfFunds;
import de.adorsys.psd2.validator.payment.config.ValidationObject;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AbstractBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.AccountReferenceValidator;
import de.adorsys.psd2.xs2a.web.validator.body.piis.v2.ConfirmationOfFundsConsentBodyValidator;
import de.adorsys.psd2.xs2a.web.validator.body.raw.FieldExtractor;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class ConfirmationOfFundsConsentBodyValidatorImpl
extends AbstractBodyValidatorImpl
implements ConfirmationOfFundsConsentBodyValidator {
    private final AccountReferenceValidator accountReferenceValidator;
    private final FieldExtractor fieldExtractor;

    public ConfirmationOfFundsConsentBodyValidatorImpl(ErrorBuildingService errorBuildingService, Xs2aObjectMapper xs2aObjectMapper, AccountReferenceValidator accountReferenceValidator, FieldExtractor fieldExtractor) {
        super(errorBuildingService, xs2aObjectMapper);
        this.accountReferenceValidator = accountReferenceValidator;
        this.fieldExtractor = fieldExtractor;
    }

    @Override
    public MessageError validate(HttpServletRequest request, MessageError messageError) {
        Optional<ConsentsConfirmationOfFunds> confirmationOfFundsOptional = this.fieldExtractor.mapBodyToInstance(request, messageError, ConsentsConfirmationOfFunds.class);
        if (confirmationOfFundsOptional.isEmpty()) {
            return messageError;
        }
        ConsentsConfirmationOfFunds confirmationOfFunds = confirmationOfFundsOptional.get();
        this.checkFieldForMaxLength(confirmationOfFunds.getCardNumber(), "cardNumber", new ValidationObject(35), messageError);
        this.checkFieldForMaxLength(confirmationOfFunds.getCardInformation(), "cardInformation", new ValidationObject(140), messageError);
        this.checkFieldForMaxLength(confirmationOfFunds.getRegistrationInformation(), "registrationInformation", new ValidationObject(140), messageError);
        if (confirmationOfFunds.getAccount() == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_VALUE, (Object[])new Object[]{"account"}));
        } else {
            this.accountReferenceValidator.validate(confirmationOfFunds.getAccount(), messageError);
        }
        return messageError;
    }
}

