/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.controller;

import de.adorsys.psd2.api.CardAccountsApi;
import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountDetailsHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountListHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardTransactionsReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReportByPeriodRequest;
import de.adorsys.psd2.xs2a.service.ais.CardAccountBalanceService;
import de.adorsys.psd2.xs2a.service.ais.CardAccountService;
import de.adorsys.psd2.xs2a.service.ais.CardTransactionService;
import de.adorsys.psd2.xs2a.service.mapper.CardAccountModelMapper;
import de.adorsys.psd2.xs2a.service.mapper.ResponseMapper;
import de.adorsys.psd2.xs2a.service.mapper.psd2.ResponseErrorMapper;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CardAccountController
implements CardAccountsApi {
    private static final Logger log = LoggerFactory.getLogger(CardAccountController.class);
    private final HttpServletRequest request;
    private final CardAccountBalanceService cardAccountBalanceService;
    private final CardAccountService cardAccountService;
    private final CardTransactionService cardTransactionService;
    private final ResponseMapper responseMapper;
    private final CardAccountModelMapper cardAccountModelMapper;
    private final ResponseErrorMapper responseErrorMapper;

    public ResponseEntity getCardAccount(UUID xRequestID, String consentID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aCardAccountListHolder> accountList = this.cardAccountService.getCardAccountList(consentID, this.trimEndingSlash(this.request.getRequestURI()));
        return accountList.hasError() ? this.responseErrorMapper.generateErrorResponse(accountList.getError()) : this.responseMapper.ok(accountList, this.cardAccountModelMapper::mapToCardAccountList);
    }

    public ResponseEntity getCardAccountBalances(String accountId, UUID xRequestID, String consentID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aBalancesReport> balancesReport = this.cardAccountBalanceService.getBalancesReport(consentID, accountId, this.trimEndingSlash(this.request.getRequestURI()));
        return balancesReport.hasError() ? this.responseErrorMapper.generateErrorResponse(balancesReport.getError()) : this.responseMapper.ok(balancesReport, this.cardAccountModelMapper::mapToBalance);
    }

    public ResponseEntity getCardAccountTransactionList(String accountId, String bookingStatus, UUID xRequestID, String consentID, LocalDate dateFrom, LocalDate dateTo, String entryReferenceFrom, Boolean deltaList, Boolean withBalance, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        Xs2aTransactionsReportByPeriodRequest xs2aTransactionsReportByPeriodRequest = new Xs2aTransactionsReportByPeriodRequest(consentID, accountId, this.request.getHeader("accept"), BooleanUtils.isTrue((Boolean)withBalance), dateFrom, dateTo, BookingStatus.forValue((String)bookingStatus), this.trimEndingSlash(this.request.getRequestURI()), entryReferenceFrom, deltaList);
        ResponseObject<Xs2aCardTransactionsReport> cardTransactionsReport = this.cardTransactionService.getCardTransactionsReportByPeriod(xs2aTransactionsReportByPeriodRequest);
        if (cardTransactionsReport.hasError()) {
            return this.responseErrorMapper.generateErrorResponse(cardTransactionsReport.getError());
        }
        if (cardTransactionsReport.getBody().isResponseContentTypeJson()) {
            return this.responseMapper.ok(cardTransactionsReport, this.cardAccountModelMapper::mapToTransactionsResponse200Json);
        }
        return this.responseMapper.ok(cardTransactionsReport, this.cardAccountModelMapper::mapToTransactionsResponseRaw);
    }

    public ResponseEntity readCardAccount(String accountId, UUID xRequestID, String consentID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        ResponseObject<Xs2aCardAccountDetailsHolder> accountDetails = this.cardAccountService.getCardAccountDetails(consentID, accountId, this.trimEndingSlash(this.request.getRequestURI()));
        return accountDetails.hasError() ? this.responseErrorMapper.generateErrorResponse(accountDetails.getError()) : this.responseMapper.ok(accountDetails, this.cardAccountModelMapper::mapToInlineResponse202);
    }

    private String trimEndingSlash(String input) {
        String result = input;
        while (StringUtils.endsWith((CharSequence)result, (CharSequence)"/")) {
            result = StringUtils.removeEnd((String)result, (String)"/");
        }
        return result;
    }

    @ConstructorProperties(value={"request", "cardAccountBalanceService", "cardAccountService", "cardTransactionService", "responseMapper", "cardAccountModelMapper", "responseErrorMapper"})
    public CardAccountController(HttpServletRequest request, CardAccountBalanceService cardAccountBalanceService, CardAccountService cardAccountService, CardTransactionService cardTransactionService, ResponseMapper responseMapper, CardAccountModelMapper cardAccountModelMapper, ResponseErrorMapper responseErrorMapper) {
        this.request = request;
        this.cardAccountBalanceService = cardAccountBalanceService;
        this.cardAccountService = cardAccountService;
        this.cardTransactionService = cardTransactionService;
        this.responseMapper = responseMapper;
        this.cardAccountModelMapper = cardAccountModelMapper;
        this.responseErrorMapper = responseErrorMapper;
    }
}

