/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.payment;

import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.validator.OauthPaymentValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.pis.AbstractPisValidator;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.GetPaymentStatusByIdPO;
import de.adorsys.psd2.xs2a.service.validator.pis.payment.TransactionStatusAcceptHeaderValidator;
import org.springframework.stereotype.Component;

@Component
public class GetPaymentStatusByIdValidator
extends AbstractPisValidator<GetPaymentStatusByIdPO> {
    private final RequestProviderService requestProviderService;
    private final OauthPaymentValidator oauthPaymentValidator;
    private final TransactionStatusAcceptHeaderValidator transactionStatusAcceptHeaderValidator;

    public GetPaymentStatusByIdValidator(RequestProviderService requestProviderService, OauthPaymentValidator oauthPaymentValidator, TransactionStatusAcceptHeaderValidator transactionStatusAcceptHeaderValidator) {
        this.requestProviderService = requestProviderService;
        this.oauthPaymentValidator = oauthPaymentValidator;
        this.transactionStatusAcceptHeaderValidator = transactionStatusAcceptHeaderValidator;
    }

    @Override
    protected ValidationResult executeBusinessValidation(GetPaymentStatusByIdPO paymentObject) {
        ValidationResult transactionStatusFormatValidationResult = this.transactionStatusAcceptHeaderValidator.validate(this.requestProviderService.getAcceptHeader());
        if (transactionStatusFormatValidationResult.isNotValid()) {
            return transactionStatusFormatValidationResult;
        }
        ValidationResult oauthPaymentValidationResult = this.oauthPaymentValidator.validate(paymentObject.getPisCommonPaymentResponse());
        if (oauthPaymentValidationResult.isNotValid()) {
            return oauthPaymentValidationResult;
        }
        return ValidationResult.valid();
    }
}

