/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.model.ConfirmationOfFunds;
import de.adorsys.psd2.model.InlineResponse2003;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.fund.FundsConfirmationRequest;
import de.adorsys.psd2.xs2a.domain.fund.FundsConfirmationResponse;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class FundsConfirmationModelMapper {
    private final Xs2aObjectMapper xs2aObjectMapper;
    private final AmountModelMapper amountModelMapper;

    public FundsConfirmationRequest mapToFundsConfirmationRequest(ConfirmationOfFunds confirmationOfFunds) {
        return Optional.ofNullable(confirmationOfFunds).map(conf -> {
            FundsConfirmationRequest fundsConfirmationRequest = new FundsConfirmationRequest();
            fundsConfirmationRequest.setCardNumber(conf.getCardNumber());
            fundsConfirmationRequest.setPayee(conf.getPayee());
            fundsConfirmationRequest.setPsuAccount(this.mapToAccountReferenceInner(conf.getAccount()));
            fundsConfirmationRequest.setInstructedAmount(this.amountModelMapper.mapToXs2aAmount(conf.getInstructedAmount()));
            return fundsConfirmationRequest;
        }).orElse(null);
    }

    public InlineResponse2003 mapToInlineResponse2003(FundsConfirmationResponse fundsConfirmationResponse) {
        return new InlineResponse2003().fundsAvailable(Boolean.valueOf(fundsConfirmationResponse.isFundsAvailable()));
    }

    private AccountReference mapToAccountReferenceInner(Object reference) {
        return (AccountReference)this.xs2aObjectMapper.convertValue(reference, AccountReference.class);
    }

    @ConstructorProperties(value={"xs2aObjectMapper", "amountModelMapper"})
    public FundsConfirmationModelMapper(Xs2aObjectMapper xs2aObjectMapper, AmountModelMapper amountModelMapper) {
        this.xs2aObjectMapper = xs2aObjectMapper;
        this.amountModelMapper = amountModelMapper;
    }
}

