/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.ais;

import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class RedirectAisAuthorizationService
implements AisAuthorizationService {
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAuthorisationService authorisationService;

    @Override
    public Optional<CreateConsentAuthorizationResponse> createConsentAuthorization(PsuIdData psuData, String consentId) {
        return this.aisConsentService.createAisConsentAuthorisation(consentId, ScaStatus.RECEIVED, psuData).map(auth -> {
            CreateConsentAuthorizationResponse resp = new CreateConsentAuthorizationResponse();
            resp.setConsentId(consentId);
            resp.setAuthorisationId(auth.getAuthorizationId());
            resp.setScaStatus(auth.getScaStatus());
            resp.setInternalRequestId(auth.getInternalRequestId());
            resp.setPsuIdData(psuData);
            return resp;
        });
    }

    @Override
    public AuthorisationProcessorResponse updateConsentPsuData(UpdateAuthorisationRequest request, AuthorisationProcessorResponse response) {
        return null;
    }

    @Override
    public Optional<Authorisation> getAccountConsentAuthorizationById(String authorizationId) {
        return this.authorisationService.getAuthorisationById(authorizationId);
    }

    @Override
    public Optional<ScaStatus> getAuthorisationScaStatus(String consentId, String authorisationId) {
        return this.aisConsentService.getAuthorisationScaStatus(consentId, authorisationId);
    }

    @Override
    public ScaApproach getScaApproachServiceType() {
        return ScaApproach.REDIRECT;
    }

    @ConstructorProperties(value={"aisConsentService", "authorisationService"})
    public RedirectAisAuthorizationService(Xs2aAisConsentService aisConsentService, Xs2aAuthorisationService authorisationService) {
        this.aisConsentService = aisConsentService;
        this.authorisationService = authorisationService;
    }
}

