/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.model.PeriodicPaymentInitiationXmlPart2StandingorderTypeJson;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.web.mapper.MultiPartBoundaryBuilder;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PaymentModelMapperXs2a {
    private static final Logger log = LoggerFactory.getLogger(PaymentModelMapperXs2a.class);
    private final HttpServletRequest httpServletRequest;
    private final Xs2aObjectMapper xs2aObjectMapper;
    private final MultiPartBoundaryBuilder multiPartBoundaryBuilder;

    public byte[] mapToXs2aPayment() {
        return this.buildBinaryBodyData(this.httpServletRequest);
    }

    public byte[] mapToXs2aRawPayment(PaymentInitiationParameters requestParameters, Object xmlSct, PeriodicPaymentInitiationXmlPart2StandingorderTypeJson jsonStandingOrderType) {
        if (requestParameters.getPaymentType() == PaymentType.PERIODIC) {
            return this.buildPeriodicBinaryBodyData(this.httpServletRequest, xmlSct, jsonStandingOrderType);
        }
        return this.buildBinaryBodyData(this.httpServletRequest);
    }

    private byte[] buildBinaryBodyData(HttpServletRequest httpServletRequest) {
        try {
            return IOUtils.toByteArray((InputStream)httpServletRequest.getInputStream());
        }
        catch (IOException e) {
            log.warn("Cannot deserialize httpServletRequest body!", (Throwable)e);
            return new byte[0];
        }
    }

    private byte[] buildPeriodicBinaryBodyData(HttpServletRequest httpServletRequest, Object xmlPart, PeriodicPaymentInitiationXmlPart2StandingorderTypeJson jsonPart) {
        String serialisedJsonPart = null;
        try {
            serialisedJsonPart = this.xs2aObjectMapper.writeValueAsString((Object)jsonPart);
        }
        catch (JsonProcessingException e) {
            log.info("Can't convert object to json: {}", (Object)e.getMessage());
        }
        if (xmlPart == null || serialisedJsonPart == null) {
            throw new IllegalArgumentException("Invalid body of the multipart request!");
        }
        String body = this.multiPartBoundaryBuilder.getMultiPartContent(httpServletRequest, (String)xmlPart, serialisedJsonPart);
        return body.getBytes(StandardCharsets.UTF_8);
    }

    @ConstructorProperties(value={"httpServletRequest", "xs2aObjectMapper", "multiPartBoundaryBuilder"})
    public PaymentModelMapperXs2a(HttpServletRequest httpServletRequest, Xs2aObjectMapper xs2aObjectMapper, MultiPartBoundaryBuilder multiPartBoundaryBuilder) {
        this.httpServletRequest = httpServletRequest;
        this.xs2aObjectMapper = xs2aObjectMapper;
        this.multiPartBoundaryBuilder = multiPartBoundaryBuilder;
    }
}

