/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
public class PsuDataUpdateAuthorisationChecker {
    public boolean canPsuUpdateAuthorisation(@NotNull PsuIdData psuIdDataRequest, @Nullable PsuIdData psuIdDataAuthorisation) {
        return this.isPsuPresent(psuIdDataAuthorisation) ? psuIdDataRequest.isEmpty() || psuIdDataAuthorisation.contentEquals(psuIdDataRequest) : psuIdDataRequest.isNotEmpty();
    }

    public boolean areBothPsusAbsent(@NotNull PsuIdData psuIdDataRequest, @Nullable PsuIdData psuIdDataAuthorisation) {
        return this.isPsuAbsent(psuIdDataAuthorisation) && this.isPsuAbsent(psuIdDataRequest);
    }

    private boolean isPsuPresent(PsuIdData psu) {
        return psu != null && psu.isNotEmpty();
    }

    private boolean isPsuAbsent(PsuIdData psu) {
        return !this.isPsuPresent(psu);
    }
}

