/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.consent;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.ais.AisConsentData;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.tpp.TppNotificationData;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.domain.AccountReferenceCollector;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateConsentReq
implements AccountReferenceCollector {
    @NotNull
    private AccountAccess access;
    private AccountAccessType availableAccounts;
    private AccountAccessType allPsd2;
    private AccountAccessType availableAccountsWithBalance;
    @NotNull
    private boolean recurringIndicator;
    @NotNull
    private LocalDate validUntil;
    @NotNull
    private int frequencyPerDay;
    @NotNull
    private boolean combinedServiceIndicator;
    private TppRedirectUri tppRedirectUri;
    private TppNotificationData tppNotificationData;
    private String tppBrandLoggingInformation;
    @Nullable
    private String instanceId;

    @Override
    @JsonIgnore
    public Set<AccountReference> getAccountReferences() {
        return this.getReferenceSet(this.access.getAccounts(), this.access.getBalances(), this.access.getTransactions());
    }

    @JsonIgnore
    public boolean isGlobalOrAllAccountsAccessConsent() {
        return this.isConsentGlobal() || this.isConsentForAllAvailableAccounts();
    }

    @SafeVarargs
    private final Set<AccountReference> getReferenceSet(List<AccountReference> ... referencesList) {
        return Arrays.stream(referencesList).map(this::getReferenceList).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private List<AccountReference> getReferenceList(List<AccountReference> reference) {
        return Optional.ofNullable(reference).orElseGet(Collections::emptyList);
    }

    private boolean isConsentGlobal() {
        return this.access.isNotEmpty(this.getAisConsentData()) && this.allPsd2 == AccountAccessType.ALL_ACCOUNTS;
    }

    @JsonIgnore
    public AisConsentData getAisConsentData() {
        return new AisConsentData(this.availableAccounts, this.allPsd2, this.availableAccountsWithBalance, this.combinedServiceIndicator);
    }

    @JsonIgnore
    public boolean isConsentForAllAvailableAccounts() {
        return this.availableAccounts == AccountAccessType.ALL_ACCOUNTS || this.availableAccountsWithBalance == AccountAccessType.ALL_ACCOUNTS;
    }

    @JsonIgnore
    public boolean isOneAccessType() {
        return !this.isRecurringIndicator();
    }

    public AccountAccess getAccess() {
        return this.access;
    }

    public AccountAccessType getAvailableAccounts() {
        return this.availableAccounts;
    }

    public AccountAccessType getAllPsd2() {
        return this.allPsd2;
    }

    public AccountAccessType getAvailableAccountsWithBalance() {
        return this.availableAccountsWithBalance;
    }

    public boolean isRecurringIndicator() {
        return this.recurringIndicator;
    }

    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    public int getFrequencyPerDay() {
        return this.frequencyPerDay;
    }

    public boolean isCombinedServiceIndicator() {
        return this.combinedServiceIndicator;
    }

    public TppRedirectUri getTppRedirectUri() {
        return this.tppRedirectUri;
    }

    public TppNotificationData getTppNotificationData() {
        return this.tppNotificationData;
    }

    public String getTppBrandLoggingInformation() {
        return this.tppBrandLoggingInformation;
    }

    @Nullable
    public String getInstanceId() {
        return this.instanceId;
    }

    public void setAccess(AccountAccess access) {
        this.access = access;
    }

    public void setAvailableAccounts(AccountAccessType availableAccounts) {
        this.availableAccounts = availableAccounts;
    }

    public void setAllPsd2(AccountAccessType allPsd2) {
        this.allPsd2 = allPsd2;
    }

    public void setAvailableAccountsWithBalance(AccountAccessType availableAccountsWithBalance) {
        this.availableAccountsWithBalance = availableAccountsWithBalance;
    }

    public void setRecurringIndicator(boolean recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
    }

    public void setValidUntil(LocalDate validUntil) {
        this.validUntil = validUntil;
    }

    public void setFrequencyPerDay(int frequencyPerDay) {
        this.frequencyPerDay = frequencyPerDay;
    }

    public void setCombinedServiceIndicator(boolean combinedServiceIndicator) {
        this.combinedServiceIndicator = combinedServiceIndicator;
    }

    public void setTppRedirectUri(TppRedirectUri tppRedirectUri) {
        this.tppRedirectUri = tppRedirectUri;
    }

    public void setTppNotificationData(TppNotificationData tppNotificationData) {
        this.tppNotificationData = tppNotificationData;
    }

    public void setTppBrandLoggingInformation(String tppBrandLoggingInformation) {
        this.tppBrandLoggingInformation = tppBrandLoggingInformation;
    }

    public void setInstanceId(@Nullable String instanceId) {
        this.instanceId = instanceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateConsentReq)) {
            return false;
        }
        CreateConsentReq other = (CreateConsentReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccountAccess this$access = this.getAccess();
        AccountAccess other$access = other.getAccess();
        if (this$access == null ? other$access != null : !this$access.equals(other$access)) {
            return false;
        }
        AccountAccessType this$availableAccounts = this.getAvailableAccounts();
        AccountAccessType other$availableAccounts = other.getAvailableAccounts();
        if (this$availableAccounts == null ? other$availableAccounts != null : !this$availableAccounts.equals(other$availableAccounts)) {
            return false;
        }
        AccountAccessType this$allPsd2 = this.getAllPsd2();
        AccountAccessType other$allPsd2 = other.getAllPsd2();
        if (this$allPsd2 == null ? other$allPsd2 != null : !this$allPsd2.equals(other$allPsd2)) {
            return false;
        }
        AccountAccessType this$availableAccountsWithBalance = this.getAvailableAccountsWithBalance();
        AccountAccessType other$availableAccountsWithBalance = other.getAvailableAccountsWithBalance();
        if (this$availableAccountsWithBalance == null ? other$availableAccountsWithBalance != null : !this$availableAccountsWithBalance.equals(other$availableAccountsWithBalance)) {
            return false;
        }
        if (this.isRecurringIndicator() != other.isRecurringIndicator()) {
            return false;
        }
        LocalDate this$validUntil = this.getValidUntil();
        LocalDate other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !((Object)this$validUntil).equals(other$validUntil)) {
            return false;
        }
        if (this.getFrequencyPerDay() != other.getFrequencyPerDay()) {
            return false;
        }
        if (this.isCombinedServiceIndicator() != other.isCombinedServiceIndicator()) {
            return false;
        }
        TppRedirectUri this$tppRedirectUri = this.getTppRedirectUri();
        TppRedirectUri other$tppRedirectUri = other.getTppRedirectUri();
        if (this$tppRedirectUri == null ? other$tppRedirectUri != null : !this$tppRedirectUri.equals(other$tppRedirectUri)) {
            return false;
        }
        TppNotificationData this$tppNotificationData = this.getTppNotificationData();
        TppNotificationData other$tppNotificationData = other.getTppNotificationData();
        if (this$tppNotificationData == null ? other$tppNotificationData != null : !this$tppNotificationData.equals(other$tppNotificationData)) {
            return false;
        }
        String this$tppBrandLoggingInformation = this.getTppBrandLoggingInformation();
        String other$tppBrandLoggingInformation = other.getTppBrandLoggingInformation();
        if (this$tppBrandLoggingInformation == null ? other$tppBrandLoggingInformation != null : !this$tppBrandLoggingInformation.equals(other$tppBrandLoggingInformation)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        return !(this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateConsentReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountAccess $access = this.getAccess();
        result = result * 59 + ($access == null ? 43 : $access.hashCode());
        AccountAccessType $availableAccounts = this.getAvailableAccounts();
        result = result * 59 + ($availableAccounts == null ? 43 : $availableAccounts.hashCode());
        AccountAccessType $allPsd2 = this.getAllPsd2();
        result = result * 59 + ($allPsd2 == null ? 43 : $allPsd2.hashCode());
        AccountAccessType $availableAccountsWithBalance = this.getAvailableAccountsWithBalance();
        result = result * 59 + ($availableAccountsWithBalance == null ? 43 : $availableAccountsWithBalance.hashCode());
        result = result * 59 + (this.isRecurringIndicator() ? 79 : 97);
        LocalDate $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : ((Object)$validUntil).hashCode());
        result = result * 59 + this.getFrequencyPerDay();
        result = result * 59 + (this.isCombinedServiceIndicator() ? 79 : 97);
        TppRedirectUri $tppRedirectUri = this.getTppRedirectUri();
        result = result * 59 + ($tppRedirectUri == null ? 43 : $tppRedirectUri.hashCode());
        TppNotificationData $tppNotificationData = this.getTppNotificationData();
        result = result * 59 + ($tppNotificationData == null ? 43 : $tppNotificationData.hashCode());
        String $tppBrandLoggingInformation = this.getTppBrandLoggingInformation();
        result = result * 59 + ($tppBrandLoggingInformation == null ? 43 : $tppBrandLoggingInformation.hashCode());
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        return result;
    }

    public String toString() {
        return "CreateConsentReq(access=" + this.getAccess() + ", availableAccounts=" + this.getAvailableAccounts() + ", allPsd2=" + this.getAllPsd2() + ", availableAccountsWithBalance=" + this.getAvailableAccountsWithBalance() + ", recurringIndicator=" + this.isRecurringIndicator() + ", validUntil=" + this.getValidUntil() + ", frequencyPerDay=" + this.getFrequencyPerDay() + ", combinedServiceIndicator=" + this.isCombinedServiceIndicator() + ", tppRedirectUri=" + this.getTppRedirectUri() + ", tppNotificationData=" + this.getTppNotificationData() + ", tppBrandLoggingInformation=" + this.getTppBrandLoggingInformation() + ", instanceId=" + this.getInstanceId() + ")";
    }
}

