package de.adorsys.psd2.xs2a.web.mapper;

import de.adorsys.psd2.model.StartScaprocessResponse;
import de.adorsys.psd2.model.UpdatePsuAuthenticationResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisCancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-02-08T09:38:39+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.2 (Oracle Corporation)"
)
@Component
public class AuthorisationModelMapperImpl extends AuthorisationModelMapper {

    @Autowired
    private CoreObjectsMapper coreObjectsMapper;
    @Autowired
    private ChosenScaMethodMapper chosenScaMethodMapper;
    @Autowired
    private ScaMethodsMapper scaMethodsMapper;

    @Override
    public StartScaprocessResponse mapToStartScaProcessResponse(Xs2aCreatePisAuthorisationResponse xs2aResponse) {
        if ( xs2aResponse == null ) {
            return null;
        }

        StartScaprocessResponse startScaprocessResponse = new StartScaprocessResponse();

        startScaprocessResponse.setScaStatus( coreObjectsMapper.mapToModelScaStatus( xs2aResponse.getScaStatus() ) );
        startScaprocessResponse.setAuthorisationId( xs2aResponse.getAuthorisationId() );

        startScaprocessResponse.setLinks( hrefLinkMapper.mapToLinksMap(xs2aResponse.getLinks()) );

        return startScaprocessResponse;
    }

    @Override
    public StartScaprocessResponse mapToStartScaProcessResponse(CreateConsentAuthorizationResponse xs2aResponse) {
        if ( xs2aResponse == null ) {
            return null;
        }

        StartScaprocessResponse startScaprocessResponse = new StartScaprocessResponse();

        startScaprocessResponse.setScaStatus( coreObjectsMapper.mapToModelScaStatus( xs2aResponse.getScaStatus() ) );
        startScaprocessResponse.setAuthorisationId( xs2aResponse.getAuthorisationId() );
        startScaprocessResponse.setPsuMessage( xs2aResponse.getPsuMessage() );

        startScaprocessResponse.setLinks( hrefLinkMapper.mapToLinksMap(xs2aResponse.getLinks()) );

        return startScaprocessResponse;
    }

    @Override
    public StartScaprocessResponse mapToStartScaProcessResponseCancellation(Xs2aCreatePisCancellationAuthorisationResponse xs2aResponse) {
        if ( xs2aResponse == null ) {
            return null;
        }

        StartScaprocessResponse startScaprocessResponse = new StartScaprocessResponse();

        startScaprocessResponse.setScaStatus( coreObjectsMapper.mapToModelScaStatus( xs2aResponse.getScaStatus() ) );
        startScaprocessResponse.setAuthorisationId( xs2aResponse.getAuthorisationId() );

        startScaprocessResponse.setLinks( hrefLinkMapper.mapToLinksMap(xs2aResponse.getLinks()) );

        return startScaprocessResponse;
    }

    @Override
    public UpdatePsuAuthenticationResponse mapToUpdatePsuAuthenticationResponse(Xs2aUpdatePisCommonPaymentPsuDataResponse xs2aResponse) {
        if ( xs2aResponse == null ) {
            return null;
        }

        UpdatePsuAuthenticationResponse updatePsuAuthenticationResponse = new UpdatePsuAuthenticationResponse();

        updatePsuAuthenticationResponse.setScaMethods( scaMethodsMapper.mapToScaMethods( xs2aResponse.getAvailableScaMethods() ) );
        updatePsuAuthenticationResponse.setChosenScaMethod( chosenScaMethodMapper.mapToChosenScaMethod( xs2aResponse.getChosenScaMethod() ) );
        updatePsuAuthenticationResponse.setChallengeData( coreObjectsMapper.mapToChallengeData( xs2aResponse.getChallengeData() ) );
        updatePsuAuthenticationResponse.setScaStatus( coreObjectsMapper.mapToModelScaStatus( xs2aResponse.getScaStatus() ) );
        updatePsuAuthenticationResponse.setPsuMessage( xs2aResponse.getPsuMessage() );
        updatePsuAuthenticationResponse.setAuthorisationId( xs2aResponse.getAuthorisationId() );

        updatePsuAuthenticationResponse.setLinks( hrefLinkMapper.mapToLinksMap(xs2aResponse.getLinks()) );

        return updatePsuAuthenticationResponse;
    }
}
