/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aConfirmationOfFundsResponse;
import de.adorsys.psd2.xs2a.domain.fund.CreatePiisConsentRequest;
import de.adorsys.psd2.xs2a.service.link.ConsentAspectService;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ConsentAspect {
    private static final Logger log = LoggerFactory.getLogger(ConsentAspect.class);
    private ConsentAspectService consentAspectService;

    public ConsentAspect(ConsentAspectService consentAspectService) {
        this.consentAspectService = consentAspectService;
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.ConsentService.createAccountConsentsWithResponse(..)) && args( request, psuData, explicitPreferred)", returning="result", argNames="result,request,psuData,explicitPreferred")
    public ResponseObject<CreateConsentResponse> invokeCreateAccountConsentAspect(ResponseObject<CreateConsentResponse> result, CreateConsentReq request, PsuIdData psuData, boolean explicitPreferred) {
        return this.consentAspectService.invokeCreateAccountConsentAspect(result, explicitPreferred);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.ConsentService.createAisAuthorisation(..)) && args( psuData,  consentId,  password)", returning="result", argNames="result, psuData,  consentId,  password")
    public ResponseObject<AuthorisationResponse> invokeCreateConsentPsuDataAspect(ResponseObject<AuthorisationResponse> result, PsuIdData psuData, String consentId, String password) {
        return this.consentAspectService.invokeCreateConsentPsuDataAspect(result);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.ConsentService.updateConsentPsuData(..)) && args(updatePsuData)", returning="result", argNames="result,updatePsuData")
    public ResponseObject<UpdateConsentPsuDataResponse> invokeUpdateConsentPsuDataAspect(ResponseObject<UpdateConsentPsuDataResponse> result, UpdateConsentPsuDataReq updatePsuData) {
        return this.consentAspectService.invokeUpdateConsentPsuDataAspect(result);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.PiisConsentService.createPiisConsentWithResponse(..)) && args( request, psuData, explicitPreferred)", returning="result", argNames="result,request,psuData,explicitPreferred")
    public ResponseObject<Xs2aConfirmationOfFundsResponse> createPiisConsentWithResponse(ResponseObject<Xs2aConfirmationOfFundsResponse> result, CreatePiisConsentRequest request, PsuIdData psuData, boolean explicitPreferred) {
        return this.consentAspectService.createPiisConsentWithResponse(result, explicitPreferred);
    }
}

