/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account;

import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.validator.OauthConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.AbstractAccountTppValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.common.AccountConsentValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.GetCardAccountListConsentObject;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GetCardAccountListValidator
extends AbstractAccountTppValidator<GetCardAccountListConsentObject> {
    private final AccountConsentValidator accountConsentValidator;
    private final OauthConsentValidator oauthConsentValidator;

    @Override
    @NotNull
    protected ValidationResult executeBusinessValidation(GetCardAccountListConsentObject consentObject) {
        AisConsent aisConsent = consentObject.getAisConsent();
        if (aisConsent.isConsentWithNotCardAccount() && !aisConsent.isConsentForAllAvailableAccounts() && !aisConsent.isGlobalConsent()) {
            return ValidationResult.invalid(ErrorType.AIS_401, MessageErrorCode.CONSENT_INVALID);
        }
        ValidationResult accountConsentValidationResult = this.accountConsentValidator.validate(aisConsent, consentObject.getRequestUri());
        if (accountConsentValidationResult.isNotValid()) {
            return accountConsentValidationResult;
        }
        ValidationResult oauthConsentValidationResult = this.oauthConsentValidator.validate(aisConsent);
        if (oauthConsentValidationResult.isNotValid()) {
            return oauthConsentValidationResult;
        }
        return ValidationResult.valid();
    }

    @ConstructorProperties(value={"accountConsentValidator", "oauthConsentValidator"})
    public GetCardAccountListValidator(AccountConsentValidator accountConsentValidator, OauthConsentValidator oauthConsentValidator) {
        this.accountConsentValidator = accountConsentValidator;
        this.oauthConsentValidator = oauthConsentValidator;
    }
}

