/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class OauthValidator<T> {
    private final RequestProviderService requestProviderService;
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;
    private final ScaApproachResolver scaApproachResolver;

    @NotNull
    public ValidationResult validate(@NotNull T object) {
        if (this.isOauthIntegrated() && this.checkObjectForTokenAbsence(object) && this.isTokenAbsent()) {
            return ValidationResult.invalid(this.getMessageError());
        }
        return ValidationResult.valid();
    }

    protected abstract boolean checkObjectForTokenAbsence(T var1);

    protected abstract MessageError getMessageError();

    private boolean isOauthIntegrated() {
        return this.scaApproachResolver.resolveScaApproach() == ScaApproach.REDIRECT && this.aspspProfileServiceWrapper.getScaRedirectFlow() == ScaRedirectFlow.OAUTH;
    }

    private boolean isTokenAbsent() {
        return StringUtils.isBlank((CharSequence)this.requestProviderService.getOAuth2Token());
    }

    @ConstructorProperties(value={"requestProviderService", "aspspProfileServiceWrapper", "scaApproachResolver"})
    public OauthValidator(RequestProviderService requestProviderService, AspspProfileServiceWrapper aspspProfileServiceWrapper, ScaApproachResolver scaApproachResolver) {
        this.requestProviderService = requestProviderService;
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
        this.scaApproachResolver = scaApproachResolver;
    }
}

