/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.create.spi;

import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.ErrorPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.payment.create.spi.PaymentInitiationService;
import de.adorsys.psd2.xs2a.service.spi.InitialSpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPaymentInitiationService<T extends CommonPayment, R extends SpiPaymentInitiationResponse>
implements PaymentInitiationService<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractPaymentInitiationService.class);
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final SpiErrorMapper spiErrorMapper;

    @Override
    public PaymentInitiationResponse initiatePayment(T payment, String paymentProduct, PsuIdData psuIdData) {
        InitialSpiAspspConsentDataProvider aspspConsentDataProvider;
        SpiContextData spiContextData = this.spiContextDataProvider.provideWithPsuIdData(psuIdData);
        SpiResponse<R> spiResponse = this.initiateSpiPayment(spiContextData, payment, paymentProduct, aspspConsentDataProvider = this.aspspConsentDataProviderFactory.getInitialAspspConsentDataProvider());
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.PIS);
            return new ErrorPaymentInitiationResponse(errorHolder);
        }
        return this.mapToXs2aResponse((SpiPaymentInitiationResponse)spiResponse.getPayload(), aspspConsentDataProvider, ((CommonPayment)payment).getPaymentType());
    }

    protected abstract SpiResponse<R> initiateSpiPayment(SpiContextData var1, T var2, String var3, InitialSpiAspspConsentDataProvider var4);

    protected abstract PaymentInitiationResponse mapToXs2aResponse(R var1, InitialSpiAspspConsentDataProvider var2, PaymentType var3);

    @ConstructorProperties(value={"spiContextDataProvider", "aspspConsentDataProviderFactory", "spiErrorMapper"})
    public AbstractPaymentInitiationService(SpiContextDataProvider spiContextDataProvider, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, SpiErrorMapper spiErrorMapper) {
        this.spiContextDataProvider = spiContextDataProvider;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.spiErrorMapper = spiErrorMapper;
    }
}

