/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.event;

import de.adorsys.psd2.event.core.model.EventOrigin;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.event.service.Xs2aEventServiceEncrypted;
import de.adorsys.psd2.event.service.model.EventBO;
import de.adorsys.psd2.xs2a.domain.RequestData;
import de.adorsys.psd2.xs2a.domain.event.RequestEventPayload;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.event.mapper.EventMapper;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Xs2aEventService {
    private static final Logger log = LoggerFactory.getLogger(Xs2aEventService.class);
    private final TppService tppService;
    private final Xs2aEventServiceEncrypted eventService;
    private final RequestProviderService requestProviderService;
    private final EventMapper eventMapper;

    public void recordAisTppRequest(@NotNull String consentId, @NotNull EventType eventType) {
        this.recordAisTppRequest(consentId, eventType, null);
    }

    public void recordAisTppRequest(@NotNull String consentId, @NotNull EventType eventType, @Nullable Object body) {
        EventBO event = this.buildTppEvent(eventType, body);
        event.setConsentId(consentId);
        this.recordEventInCms(event);
    }

    public void recordPisTppRequest(@NotNull String paymentId, @NotNull EventType eventType) {
        this.recordPisTppRequest(paymentId, eventType, null);
    }

    public void recordPisTppRequest(@NotNull String paymentId, @NotNull EventType eventType, @Nullable Object body) {
        EventBO event = this.buildTppEvent(eventType, body);
        event.setPaymentId(paymentId);
        this.recordEventInCms(event);
    }

    public void recordTppRequest(@NotNull EventType eventType) {
        this.recordTppRequest(eventType, null);
    }

    public void recordTppRequest(@NotNull EventType eventType, @Nullable Object body) {
        EventBO event = this.buildTppEvent(eventType, body);
        this.recordEventInCms(event);
    }

    private void recordEventInCms(EventBO event) {
        boolean recorded = this.eventService.recordEvent(event);
        if (!recorded) {
            log.info("TPP ID: [{}]. Couldn't record event from TPP request: {}", (Object)event.getTppAuthorisationNumber(), (Object)event);
        }
    }

    private EventBO buildTppEvent(EventType eventType, Object body) {
        RequestData requestData = this.requestProviderService.getRequestData();
        EventBO event = EventBO.builder().timestamp(OffsetDateTime.now()).eventOrigin(EventOrigin.TPP).eventType(eventType).psuIdData(this.eventMapper.toEventPsuIdData(requestData.getPsuIdData())).xRequestId(requestData.getRequestId()).internalRequestId(requestData.getInternalRequestId()).instanceId(this.requestProviderService.getInstanceId()).tppAuthorisationNumber(this.tppService.getTppInfo().getAuthorisationNumber()).build();
        RequestEventPayload payload = this.buildRequestEventPayload(requestData, body);
        event.setPayload((Object)payload);
        return event;
    }

    private RequestEventPayload buildRequestEventPayload(RequestData requestData, Object body) {
        RequestEventPayload requestPayload = new RequestEventPayload();
        requestPayload.setTppInfo(this.tppService.getTppInfo());
        requestPayload.setTppIp(requestData.getIp());
        requestPayload.setUri(requestData.getUri());
        requestPayload.setHeaders(requestData.getHeaders());
        requestPayload.setBody(body);
        return requestPayload;
    }

    @ConstructorProperties(value={"tppService", "eventService", "requestProviderService", "eventMapper"})
    public Xs2aEventService(TppService tppService, Xs2aEventServiceEncrypted eventService, RequestProviderService requestProviderService, EventMapper eventMapper) {
        this.tppService = tppService;
        this.eventService = eventService;
        this.requestProviderService = requestProviderService;
        this.eventMapper = eventMapper;
    }
}

