/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.tpp;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.tpp.TppInfoCheckerService;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class TppInfoValidator {
    private static final Logger log = LoggerFactory.getLogger(TppInfoValidator.class);
    private final TppInfoCheckerService tppInfoCheckerService;

    public ValidationResult validateTpp(@Nullable TppInfo tppInfo) {
        if (this.tppInfoCheckerService.differsFromTppInRequest(tppInfo)) {
            log.info("TPP validation has failed: TPP in consent/payment doesn't match the TPP in request");
            return ValidationResult.invalid(this.getErrorType(), this.getTppMessageInformation());
        }
        return ValidationResult.valid();
    }

    abstract ErrorType getErrorType();

    abstract TppMessageInformation getTppMessageInformation();

    @ConstructorProperties(value={"tppInfoCheckerService"})
    public TppInfoValidator(TppInfoCheckerService tppInfoCheckerService) {
        this.tppInfoCheckerService = tppInfoCheckerService;
    }
}

