/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.ais.account.dto;

import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.service.validator.TppInfoProvider;
import java.beans.ConstructorProperties;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class GetCardAccountDetailsRequestObject
implements TppInfoProvider {
    @NotNull
    private final AisConsent aisConsent;
    private final String accountId;
    private final String requestUri;

    @Override
    public TppInfo getTppInfo() {
        return this.aisConsent.getTppInfo();
    }

    public List<AccountReference> getAccounts() {
        return this.aisConsent.getAccess().getAccounts();
    }

    public List<AccountReference> getTransactions() {
        return this.aisConsent.getAccess().getTransactions();
    }

    @ConstructorProperties(value={"aisConsent", "accountId", "requestUri"})
    public GetCardAccountDetailsRequestObject(@NotNull AisConsent aisConsent, String accountId, String requestUri) {
        if (aisConsent == null) {
            throw new NullPointerException("aisConsent is marked @NonNull but is null");
        }
        this.aisConsent = aisConsent;
        this.accountId = accountId;
        this.requestUri = requestUri;
    }

    @NotNull
    public AisConsent getAisConsent() {
        return this.aisConsent;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetCardAccountDetailsRequestObject)) {
            return false;
        }
        GetCardAccountDetailsRequestObject other = (GetCardAccountDetailsRequestObject)o;
        AisConsent this$aisConsent = this.getAisConsent();
        AisConsent other$aisConsent = other.getAisConsent();
        if (this$aisConsent == null ? other$aisConsent != null : !this$aisConsent.equals(other$aisConsent)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        String this$requestUri = this.getRequestUri();
        String other$requestUri = other.getRequestUri();
        return !(this$requestUri == null ? other$requestUri != null : !this$requestUri.equals(other$requestUri));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AisConsent $aisConsent = this.getAisConsent();
        result = result * 59 + ($aisConsent == null ? 43 : $aisConsent.hashCode());
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        String $requestUri = this.getRequestUri();
        result = result * 59 + ($requestUri == null ? 43 : $requestUri.hashCode());
        return result;
    }

    public String toString() {
        return "GetCardAccountDetailsRequestObject(aisConsent=" + this.getAisConsent() + ", accountId=" + this.getAccountId() + ", requestUri=" + this.getRequestUri() + ")";
    }
}

