/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.validator.BusinessValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.tpp.TppDomainValidator;
import de.adorsys.psd2.xs2a.web.validator.header.ConsentHeaderValidator;
import de.adorsys.psd2.xs2a.web.validator.header.PaymentHeaderValidator;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class TppUriHeaderValidator
implements BusinessValidator<TppRedirectUri>,
PaymentHeaderValidator,
ConsentHeaderValidator {
    private final TppDomainValidator tppDomainValidator;
    private final ScaApproachResolver scaApproachResolver;

    @Override
    @NotNull
    public ValidationResult validate(@NotNull TppRedirectUri tppRedirectUri) {
        return ValidationResult.valid();
    }

    @Override
    @NotNull
    public Set<TppMessageInformation> buildWarningMessages(@NotNull TppRedirectUri tppRedirectUri) {
        HashSet<TppMessageInformation> warnings = new HashSet<TppMessageInformation>();
        if (this.isRedirectScaApproach()) {
            warnings.addAll(this.tppDomainValidator.buildWarningMessages(tppRedirectUri.getUri()));
            if (StringUtils.isNotBlank((CharSequence)tppRedirectUri.getNokUri())) {
                warnings.addAll(this.tppDomainValidator.buildWarningMessages(tppRedirectUri.getNokUri()));
            }
        }
        return warnings;
    }

    private boolean isRedirectScaApproach() {
        return ScaApproach.REDIRECT == this.scaApproachResolver.resolveScaApproach();
    }

    @Override
    public MessageError validate(Map<String, String> headers, MessageError messageError) {
        ValidationResult uriValidationResult = this.tppDomainValidator.validate(headers.get("tpp-redirect-uri"));
        if (uriValidationResult.isNotValid()) {
            return uriValidationResult.getMessageError();
        }
        ValidationResult nokUriValidationResult = this.tppDomainValidator.validate(headers.get("tpp-nok-redirect-uri"));
        if (nokUriValidationResult.isNotValid()) {
            return nokUriValidationResult.getMessageError();
        }
        return messageError;
    }

    @ConstructorProperties(value={"tppDomainValidator", "scaApproachResolver"})
    public TppUriHeaderValidator(TppDomainValidator tppDomainValidator, ScaApproachResolver scaApproachResolver) {
        this.tppDomainValidator = tppDomainValidator;
        this.scaApproachResolver = scaApproachResolver;
    }
}

