/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.core.pis.Remittance;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiAddressMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiAmountMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.web.mapper.RemittanceMapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class Xs2aToSpiPeriodicPaymentMapper {
    private final Xs2aToSpiAmountMapper xs2aToSpiAmountMapper;
    private final Xs2aToSpiAddressMapper xs2aToSpiAddressMapper;
    private final Xs2aToSpiAccountReferenceMapper xs2aToSpiAccountReferenceMapper;
    private final Xs2aToSpiPsuDataMapper xs2aToSpiPsuDataMapper;
    private final RemittanceMapper remittanceMapper;

    public SpiPeriodicPayment mapToSpiPeriodicPayment(PeriodicPayment payment, String paymentProduct) {
        SpiPeriodicPayment periodic = new SpiPeriodicPayment(paymentProduct);
        periodic.setPaymentId(payment.getPaymentId());
        periodic.setEndToEndIdentification(payment.getEndToEndIdentification());
        periodic.setInstructionIdentification(payment.getInstructionIdentification());
        periodic.setDebtorAccount(this.xs2aToSpiAccountReferenceMapper.mapToSpiAccountReference(payment.getDebtorAccount()));
        periodic.setInstructedAmount(this.xs2aToSpiAmountMapper.mapToSpiAmount(payment.getInstructedAmount()));
        periodic.setCreditorAccount(this.xs2aToSpiAccountReferenceMapper.mapToSpiAccountReference(payment.getCreditorAccount()));
        periodic.setCreditorAgent(payment.getCreditorAgent());
        periodic.setCreditorName(payment.getCreditorName());
        periodic.setCreditorAddress(this.xs2aToSpiAddressMapper.mapToSpiAddress(payment.getCreditorAddress()));
        periodic.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        periodic.setStartDate(payment.getStartDate());
        periodic.setEndDate(payment.getEndDate());
        periodic.setExecutionRule(payment.getExecutionRule());
        if (payment.getTransactionStatus() != null) {
            periodic.setPaymentStatus(payment.getTransactionStatus());
        }
        periodic.setFrequency(payment.getFrequency());
        periodic.setDayOfExecution(payment.getDayOfExecution());
        periodic.setRequestedExecutionTime(payment.getRequestedExecutionTime());
        periodic.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        periodic.setPsuDataList(this.xs2aToSpiPsuDataMapper.mapToSpiPsuDataList(payment.getPsuDataList()));
        periodic.setStatusChangeTimestamp(payment.getStatusChangeTimestamp());
        periodic.setUltimateDebtor(payment.getUltimateDebtor());
        periodic.setUltimateCreditor(payment.getUltimateCreditor());
        periodic.setPurposeCode(payment.getPurposeCode());
        periodic.setRemittanceInformationStructured(this.remittanceMapper.mapToSpiRemittance(payment.getRemittanceInformationStructured()));
        List<Remittance> remittanceInformationStructuredArray = payment.getRemittanceInformationStructuredArray();
        if (remittanceInformationStructuredArray != null) {
            periodic.setRemittanceInformationStructuredArray(remittanceInformationStructuredArray.stream().map(this.remittanceMapper::mapToSpiRemittance).collect(Collectors.toList()));
        }
        periodic.setCreationTimestamp(payment.getCreationTimestamp());
        periodic.setContentType(payment.getContentType());
        periodic.setDebtorName(payment.getDebtorName());
        periodic.setInstanceId(payment.getInstanceId());
        return periodic;
    }

    @ConstructorProperties(value={"xs2aToSpiAmountMapper", "xs2aToSpiAddressMapper", "xs2aToSpiAccountReferenceMapper", "xs2aToSpiPsuDataMapper", "remittanceMapper"})
    public Xs2aToSpiPeriodicPaymentMapper(Xs2aToSpiAmountMapper xs2aToSpiAmountMapper, Xs2aToSpiAddressMapper xs2aToSpiAddressMapper, Xs2aToSpiAccountReferenceMapper xs2aToSpiAccountReferenceMapper, Xs2aToSpiPsuDataMapper xs2aToSpiPsuDataMapper, RemittanceMapper remittanceMapper) {
        this.xs2aToSpiAmountMapper = xs2aToSpiAmountMapper;
        this.xs2aToSpiAddressMapper = xs2aToSpiAddressMapper;
        this.xs2aToSpiAccountReferenceMapper = xs2aToSpiAccountReferenceMapper;
        this.xs2aToSpiPsuDataMapper = xs2aToSpiPsuDataMapper;
        this.remittanceMapper = remittanceMapper;
    }
}

