package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.AccountDetails;
import de.adorsys.psd2.model.AccountDetails.UsageEnum;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.AccountReport;
import de.adorsys.psd2.model.AccountStatus;
import de.adorsys.psd2.model.AdditionalInformationStructured;
import de.adorsys.psd2.model.Balance;
import de.adorsys.psd2.model.DayOfExecution;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.model.MonthsOfExecution;
import de.adorsys.psd2.model.ReadAccountBalanceResponse200;
import de.adorsys.psd2.model.RemittanceInformationStructured;
import de.adorsys.psd2.model.RemittanceInformationStructuredArray;
import de.adorsys.psd2.model.RemittanceInformationUnstructuredArray;
import de.adorsys.psd2.model.ReportExchangeRate;
import de.adorsys.psd2.model.StandingOrderDetails;
import de.adorsys.psd2.model.TransactionDetails;
import de.adorsys.psd2.model.TransactionsResponse200Json;
import de.adorsys.psd2.xs2a.core.pis.PisDayOfExecution;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import de.adorsys.psd2.xs2a.core.pis.Remittance;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.Xs2aBalance;
import de.adorsys.psd2.xs2a.domain.Xs2aExchangeRate;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAdditionalInformationStructured;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aStandingOrderDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aUsageType;
import de.adorsys.psd2.xs2a.domain.code.BankTransactionCode;
import de.adorsys.psd2.xs2a.web.mapper.PurposeCodeMapper;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-10-01T08:30:29+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.2 (Oracle Corporation)"
)
@Component
public class AccountModelMapperImpl extends AccountModelMapper {

    @Autowired
    private AmountModelMapper amountModelMapper;
    @Autowired
    private PurposeCodeMapper purposeCodeMapper;

    @Override
    public AccountReference mapToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }

        AccountReference accountReference1 = new AccountReference();

        accountReference1.setCurrency( accountReferenceCurrencyCurrencyCode( accountReference ) );
        accountReference1.setIban( accountReference.getIban() );
        accountReference1.setBban( accountReference.getBban() );
        accountReference1.setPan( accountReference.getPan() );
        accountReference1.setMaskedPan( accountReference.getMaskedPan() );
        accountReference1.setMsisdn( accountReference.getMsisdn() );

        return accountReference1;
    }

    @Override
    public List<AccountReference> mapToAccountReferences(List<de.adorsys.psd2.xs2a.core.profile.AccountReference> accountReferences) {
        if ( accountReferences == null ) {
            return null;
        }

        List<AccountReference> list = new ArrayList<AccountReference>( accountReferences.size() );
        for ( de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference : accountReferences ) {
            list.add( mapToAccountReference( accountReference ) );
        }

        return list;
    }

    @Override
    public AccountDetails mapToAccountDetails(Xs2aAccountDetails accountDetails) {
        if ( accountDetails == null ) {
            return null;
        }

        AccountDetails accountDetails1 = new AccountDetails();

        accountDetails1.setUsage( xs2aUsageTypeToUsageEnum( accountDetails.getUsageType() ) );
        accountDetails1.setStatus( accountStatusToAccountStatus( accountDetails.getAccountStatus() ) );
        accountDetails1.setResourceId( accountDetails.getResourceId() );
        accountDetails1.setIban( accountDetails.getIban() );
        accountDetails1.setBban( accountDetails.getBban() );
        accountDetails1.setMsisdn( accountDetails.getMsisdn() );
        accountDetails1.setName( accountDetails.getName() );
        accountDetails1.setDisplayName( accountDetails.getDisplayName() );
        accountDetails1.setProduct( accountDetails.getProduct() );
        if ( accountDetails.getCashAccountType() != null ) {
            accountDetails1.setCashAccountType( accountDetails.getCashAccountType().name() );
        }
        accountDetails1.setBic( accountDetails.getBic() );
        accountDetails1.setLinkedAccounts( accountDetails.getLinkedAccounts() );
        accountDetails1.setDetails( accountDetails.getDetails() );
        accountDetails1.setBalances( mapToBalanceList( accountDetails.getBalances() ) );
        accountDetails1.setOwnerName( accountDetails.getOwnerName() );

        accountDetails1.setLinks( hrefLinkMapper.mapToLinksMap(accountDetails.getLinks()) );
        accountDetails1.setCurrency( mapToAccountDetailsCurrency(accountDetails.getCurrency()) );

        return accountDetails1;
    }

    @Override
    public Balance mapToBalance(Xs2aBalance balance) {
        if ( balance == null ) {
            return null;
        }

        Balance balance1 = new Balance();

        balance1.setBalanceAmount( amountModelMapper.mapToAmount( balance.getBalanceAmount() ) );
        balance1.setCreditLimitIncluded( balance.getCreditLimitIncluded() );
        balance1.setReferenceDate( balance.getReferenceDate() );
        balance1.setLastCommittedTransaction( balance.getLastCommittedTransaction() );

        balance1.setLastChangeDateTime( mapToOffsetDateTime(balance.getLastChangeDateTime()) );
        balance1.setBalanceType( mapToBalanceType(balance.getBalanceType()) );

        return balance1;
    }

    @Override
    public ReadAccountBalanceResponse200 mapToBalance(Xs2aBalancesReport balancesReport) {
        if ( balancesReport == null ) {
            return null;
        }

        ReadAccountBalanceResponse200 readAccountBalanceResponse200 = new ReadAccountBalanceResponse200();

        readAccountBalanceResponse200.setAccount( mapToAccountReference( balancesReport.getXs2aAccountReference() ) );
        readAccountBalanceResponse200.setBalances( mapToBalanceList( balancesReport.getBalances() ) );

        return readAccountBalanceResponse200;
    }

    @Override
    public AccountReport mapToAccountReport(Xs2aAccountReport accountReport) {
        if ( accountReport == null ) {
            return null;
        }

        AccountReport accountReport1 = new AccountReport();

        accountReport1.setBooked( mapToTransactionList( accountReport.getBooked() ) );
        accountReport1.setInformation( mapToTransactionList( accountReport.getInformation() ) );
        accountReport1.setPending( mapToTransactionList( accountReport.getPending() ) );

        accountReport1.setLinks( hrefLinkMapper.mapToLinksMap(accountReport.getLinks()) );

        return accountReport1;
    }

    @Override
    public TransactionsResponse200Json mapToTransactionsResponse200Json(Xs2aTransactionsReport transactionsReport) {
        if ( transactionsReport == null ) {
            return null;
        }

        TransactionsResponse200Json transactionsResponse200Json = new TransactionsResponse200Json();

        transactionsResponse200Json.setTransactions( mapToAccountReport( transactionsReport.getAccountReport() ) );
        transactionsResponse200Json.setAccount( mapToAccountReference( transactionsReport.getAccountReference() ) );
        transactionsResponse200Json.setBalances( mapToBalanceList( transactionsReport.getBalances() ) );

        transactionsResponse200Json.setLinks( hrefLinkMapper.mapToLinksMap(transactionsReport.getLinks()) );

        return transactionsResponse200Json;
    }

    @Override
    public TransactionDetails mapToTransaction(Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }

        TransactionDetails transactionDetails = new TransactionDetails();

        transactionDetails.setBankTransactionCode( transactionsBankTransactionCodeCodeCode( transactions ) );
        transactionDetails.setTransactionAmount( amountModelMapper.mapToAmount( transactions.getAmount() ) );
        transactionDetails.setTransactionId( transactions.getTransactionId() );
        transactionDetails.setEntryReference( transactions.getEntryReference() );
        transactionDetails.setEndToEndId( transactions.getEndToEndId() );
        transactionDetails.setMandateId( transactions.getMandateId() );
        transactionDetails.setCheckId( transactions.getCheckId() );
        transactionDetails.setCreditorId( transactions.getCreditorId() );
        transactionDetails.setBookingDate( transactions.getBookingDate() );
        transactionDetails.setValueDate( transactions.getValueDate() );
        transactionDetails.setCreditorName( transactions.getCreditorName() );
        transactionDetails.setCreditorAccount( mapToAccountReference( transactions.getCreditorAccount() ) );
        transactionDetails.setCreditorAgent( transactions.getCreditorAgent() );
        transactionDetails.setUltimateCreditor( transactions.getUltimateCreditor() );
        transactionDetails.setDebtorName( transactions.getDebtorName() );
        transactionDetails.setDebtorAccount( mapToAccountReference( transactions.getDebtorAccount() ) );
        transactionDetails.setDebtorAgent( transactions.getDebtorAgent() );
        transactionDetails.setUltimateDebtor( transactions.getUltimateDebtor() );
        transactionDetails.setRemittanceInformationUnstructured( transactions.getRemittanceInformationUnstructured() );
        transactionDetails.setRemittanceInformationUnstructuredArray( stringListToRemittanceInformationUnstructuredArray( transactions.getRemittanceInformationUnstructuredArray() ) );
        transactionDetails.setRemittanceInformationStructured( remittanceToRemittanceInformationStructured( transactions.getRemittanceInformationStructured() ) );
        transactionDetails.setRemittanceInformationStructuredArray( remittanceListToRemittanceInformationStructuredArray( transactions.getRemittanceInformationStructuredArray() ) );
        transactionDetails.setAdditionalInformation( transactions.getAdditionalInformation() );
        transactionDetails.setAdditionalInformationStructured( xs2aAdditionalInformationStructuredToAdditionalInformationStructured( transactions.getAdditionalInformationStructured() ) );
        transactionDetails.setPurposeCode( purposeCodeMapper.mapToPurposeCode( transactions.getPurposeCode() ) );
        transactionDetails.setProprietaryBankTransactionCode( transactions.getProprietaryBankTransactionCode() );
        transactionDetails.setBalanceAfterTransaction( mapToBalance( transactions.getBalanceAfterTransaction() ) );

        transactionDetails.setCurrencyExchange( mapToReportExchanges(transactions.getExchangeRate()) );

        return transactionDetails;
    }

    @Override
    protected ReportExchangeRate mapToReportExchangeRate(Xs2aExchangeRate xs2aExchangeRate) {
        if ( xs2aExchangeRate == null ) {
            return null;
        }

        ReportExchangeRate reportExchangeRate = new ReportExchangeRate();

        reportExchangeRate.setSourceCurrency( xs2aExchangeRate.getSourceCurrency() );
        reportExchangeRate.setExchangeRate( xs2aExchangeRate.getExchangeRate() );
        reportExchangeRate.setUnitCurrency( xs2aExchangeRate.getUnitCurrency() );
        reportExchangeRate.setTargetCurrency( xs2aExchangeRate.getTargetCurrency() );
        reportExchangeRate.setQuotationDate( xs2aExchangeRate.getQuotationDate() );
        reportExchangeRate.setContractIdentification( xs2aExchangeRate.getContractIdentification() );

        return reportExchangeRate;
    }

    private String accountReferenceCurrencyCurrencyCode(de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }
        Currency currency = accountReference.getCurrency();
        if ( currency == null ) {
            return null;
        }
        String currencyCode = currency.getCurrencyCode();
        if ( currencyCode == null ) {
            return null;
        }
        return currencyCode;
    }

    protected UsageEnum xs2aUsageTypeToUsageEnum(Xs2aUsageType xs2aUsageType) {
        if ( xs2aUsageType == null ) {
            return null;
        }

        UsageEnum usageEnum;

        switch ( xs2aUsageType ) {
            case PRIV: usageEnum = UsageEnum.PRIV;
            break;
            case ORGA: usageEnum = UsageEnum.ORGA;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + xs2aUsageType );
        }

        return usageEnum;
    }

    protected AccountStatus accountStatusToAccountStatus(de.adorsys.psd2.xs2a.domain.account.AccountStatus accountStatus) {
        if ( accountStatus == null ) {
            return null;
        }

        AccountStatus accountStatus1;

        switch ( accountStatus ) {
            case ENABLED: accountStatus1 = AccountStatus.ENABLED;
            break;
            case DELETED: accountStatus1 = AccountStatus.DELETED;
            break;
            case BLOCKED: accountStatus1 = AccountStatus.BLOCKED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accountStatus );
        }

        return accountStatus1;
    }

    private String transactionsBankTransactionCodeCodeCode(Transactions transactions) {
        if ( transactions == null ) {
            return null;
        }
        BankTransactionCode bankTransactionCodeCode = transactions.getBankTransactionCodeCode();
        if ( bankTransactionCodeCode == null ) {
            return null;
        }
        String code = bankTransactionCodeCode.getCode();
        if ( code == null ) {
            return null;
        }
        return code;
    }

    protected RemittanceInformationUnstructuredArray stringListToRemittanceInformationUnstructuredArray(List<String> list) {
        if ( list == null ) {
            return null;
        }

        RemittanceInformationUnstructuredArray remittanceInformationUnstructuredArray = new RemittanceInformationUnstructuredArray();
        for ( String string : list ) {
            remittanceInformationUnstructuredArray.add( string );
        }

        return remittanceInformationUnstructuredArray;
    }

    protected RemittanceInformationStructured remittanceToRemittanceInformationStructured(Remittance remittance) {
        if ( remittance == null ) {
            return null;
        }

        RemittanceInformationStructured remittanceInformationStructured = new RemittanceInformationStructured();

        remittanceInformationStructured.setReference( remittance.getReference() );
        remittanceInformationStructured.setReferenceType( remittance.getReferenceType() );
        remittanceInformationStructured.setReferenceIssuer( remittance.getReferenceIssuer() );

        return remittanceInformationStructured;
    }

    protected RemittanceInformationStructuredArray remittanceListToRemittanceInformationStructuredArray(List<Remittance> list) {
        if ( list == null ) {
            return null;
        }

        RemittanceInformationStructuredArray remittanceInformationStructuredArray = new RemittanceInformationStructuredArray();
        for ( Remittance remittance : list ) {
            remittanceInformationStructuredArray.add( remittanceToRemittanceInformationStructured( remittance ) );
        }

        return remittanceInformationStructuredArray;
    }

    protected FrequencyCode frequencyCodeToFrequencyCode(de.adorsys.psd2.xs2a.core.pis.FrequencyCode frequencyCode) {
        if ( frequencyCode == null ) {
            return null;
        }

        FrequencyCode frequencyCode1;

        switch ( frequencyCode ) {
            case DAILY: frequencyCode1 = FrequencyCode.DAILY;
            break;
            case WEEKLY: frequencyCode1 = FrequencyCode.WEEKLY;
            break;
            case EVERYTWOWEEKS: frequencyCode1 = FrequencyCode.EVERYTWOWEEKS;
            break;
            case MONTHLY: frequencyCode1 = FrequencyCode.MONTHLY;
            break;
            case EVERYTWOMONTHS: frequencyCode1 = FrequencyCode.EVERYTWOMONTHS;
            break;
            case QUARTERLY: frequencyCode1 = FrequencyCode.QUARTERLY;
            break;
            case SEMIANNUAL: frequencyCode1 = FrequencyCode.SEMIANNUAL;
            break;
            case ANNUAL: frequencyCode1 = FrequencyCode.ANNUAL;
            break;
            case MONTHLYVARIABLE: frequencyCode1 = FrequencyCode.MONTHLYVARIABLE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + frequencyCode );
        }

        return frequencyCode1;
    }

    protected ExecutionRule pisExecutionRuleToExecutionRule(PisExecutionRule pisExecutionRule) {
        if ( pisExecutionRule == null ) {
            return null;
        }

        ExecutionRule executionRule;

        switch ( pisExecutionRule ) {
            case FOLLOWING: executionRule = ExecutionRule.FOLLOWING;
            break;
            case PRECEDING: executionRule = ExecutionRule.PRECEDING;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + pisExecutionRule );
        }

        return executionRule;
    }

    protected MonthsOfExecution stringListToMonthsOfExecution(List<String> list) {
        if ( list == null ) {
            return null;
        }

        MonthsOfExecution monthsOfExecution = new MonthsOfExecution();
        for ( String string : list ) {
            monthsOfExecution.add( string );
        }

        return monthsOfExecution;
    }

    protected DayOfExecution pisDayOfExecutionToDayOfExecution(PisDayOfExecution pisDayOfExecution) {
        if ( pisDayOfExecution == null ) {
            return null;
        }

        DayOfExecution dayOfExecution;

        switch ( pisDayOfExecution ) {
            case _1: dayOfExecution = DayOfExecution._1;
            break;
            case _2: dayOfExecution = DayOfExecution._2;
            break;
            case _3: dayOfExecution = DayOfExecution._3;
            break;
            case _4: dayOfExecution = DayOfExecution._4;
            break;
            case _5: dayOfExecution = DayOfExecution._5;
            break;
            case _6: dayOfExecution = DayOfExecution._6;
            break;
            case _7: dayOfExecution = DayOfExecution._7;
            break;
            case _8: dayOfExecution = DayOfExecution._8;
            break;
            case _9: dayOfExecution = DayOfExecution._9;
            break;
            case _10: dayOfExecution = DayOfExecution._10;
            break;
            case _11: dayOfExecution = DayOfExecution._11;
            break;
            case _12: dayOfExecution = DayOfExecution._12;
            break;
            case _13: dayOfExecution = DayOfExecution._13;
            break;
            case _14: dayOfExecution = DayOfExecution._14;
            break;
            case _15: dayOfExecution = DayOfExecution._15;
            break;
            case _16: dayOfExecution = DayOfExecution._16;
            break;
            case _17: dayOfExecution = DayOfExecution._17;
            break;
            case _18: dayOfExecution = DayOfExecution._18;
            break;
            case _19: dayOfExecution = DayOfExecution._19;
            break;
            case _20: dayOfExecution = DayOfExecution._20;
            break;
            case _21: dayOfExecution = DayOfExecution._21;
            break;
            case _22: dayOfExecution = DayOfExecution._22;
            break;
            case _23: dayOfExecution = DayOfExecution._23;
            break;
            case _24: dayOfExecution = DayOfExecution._24;
            break;
            case _25: dayOfExecution = DayOfExecution._25;
            break;
            case _26: dayOfExecution = DayOfExecution._26;
            break;
            case _27: dayOfExecution = DayOfExecution._27;
            break;
            case _28: dayOfExecution = DayOfExecution._28;
            break;
            case _29: dayOfExecution = DayOfExecution._29;
            break;
            case _30: dayOfExecution = DayOfExecution._30;
            break;
            case _31: dayOfExecution = DayOfExecution._31;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + pisDayOfExecution );
        }

        return dayOfExecution;
    }

    protected StandingOrderDetails xs2aStandingOrderDetailsToStandingOrderDetails(Xs2aStandingOrderDetails xs2aStandingOrderDetails) {
        if ( xs2aStandingOrderDetails == null ) {
            return null;
        }

        StandingOrderDetails standingOrderDetails = new StandingOrderDetails();

        standingOrderDetails.setStartDate( xs2aStandingOrderDetails.getStartDate() );
        standingOrderDetails.setFrequency( frequencyCodeToFrequencyCode( xs2aStandingOrderDetails.getFrequency() ) );
        standingOrderDetails.setEndDate( xs2aStandingOrderDetails.getEndDate() );
        standingOrderDetails.setExecutionRule( pisExecutionRuleToExecutionRule( xs2aStandingOrderDetails.getExecutionRule() ) );
        standingOrderDetails.setWithinAMonthFlag( xs2aStandingOrderDetails.getWithinAMonthFlag() );
        standingOrderDetails.setMonthsOfExecution( stringListToMonthsOfExecution( xs2aStandingOrderDetails.getMonthsOfExecution() ) );
        standingOrderDetails.setMultiplicator( xs2aStandingOrderDetails.getMultiplicator() );
        standingOrderDetails.setDayOfExecution( pisDayOfExecutionToDayOfExecution( xs2aStandingOrderDetails.getDayOfExecution() ) );
        standingOrderDetails.setLimitAmount( amountModelMapper.mapToAmount( xs2aStandingOrderDetails.getLimitAmount() ) );

        return standingOrderDetails;
    }

    protected AdditionalInformationStructured xs2aAdditionalInformationStructuredToAdditionalInformationStructured(Xs2aAdditionalInformationStructured xs2aAdditionalInformationStructured) {
        if ( xs2aAdditionalInformationStructured == null ) {
            return null;
        }

        AdditionalInformationStructured additionalInformationStructured = new AdditionalInformationStructured();

        additionalInformationStructured.setStandingOrderDetails( xs2aStandingOrderDetailsToStandingOrderDetails( xs2aAdditionalInformationStructured.getStandingOrderDetails() ) );

        return additionalInformationStructured;
    }
}
