/*
 * Copyright 2018-2020 adorsys GmbH & Co KG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.adorsys.psd2.xs2a.service.discovery;

import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UrlPathHelper;

import javax.servlet.http.HttpServletRequest;

@Service
@RequiredArgsConstructor
public class ServiceTypeDiscoveryService {
    private final HttpServletRequest request;

    /**
     * Gets service type from request URI by invoking ServiceTypeDiscovery
     *
     * @return ServiceType value
     */
    public ServiceType getServiceType() {
        return ServiceTypeDiscovery.getServiceType(new UrlPathHelper().getPathWithinApplication(request));
    }
}

