/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.ais;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountDetailsHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountListHolder;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.ais.AccountHelperService;
import de.adorsys.psd2.xs2a.service.consent.AccountReferenceInConsentUpdater;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountDetailsMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetCardAccountDetailsValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetCardAccountListValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.GetCardAccountDetailsRequestObject;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.GetCardAccountListConsentObject;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiCardAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.CardAccountSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CardAccountService {
    private static final Logger log = LoggerFactory.getLogger(CardAccountService.class);
    private final CardAccountSpi cardAccountSpi;
    private final SpiToXs2aAccountDetailsMapper accountDetailsMapper;
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAisConsentMapper consentMapper;
    private final TppService tppService;
    private final Xs2aEventService xs2aEventService;
    private final AccountReferenceInConsentUpdater accountReferenceUpdater;
    private final SpiErrorMapper spiErrorMapper;
    private final GetCardAccountListValidator getCardAccountListValidator;
    private final GetCardAccountDetailsValidator getCardAccountDetailsValidator;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final AccountHelperService accountHelperService;
    private final LoggingContextService loggingContextService;

    public ResponseObject<Xs2aCardAccountListHolder> getCardAccountList(String consentId, String requestUri) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_CARD_ACCOUNT_LIST_REQUEST_RECEIVED);
        Optional<AisConsent> aisConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (aisConsentOptional.isEmpty()) {
            log.info("Consent-ID [{}]. Get card account list failed. Account consent not found by ID", (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AisConsent aisConsent = aisConsentOptional.get();
        ValidationResult validationResult = this.getCardAccountListValidator.validate(new GetCardAccountListConsentObject(aisConsent, requestUri));
        if (validationResult.isNotValid()) {
            log.info("Consent-ID [{}], RequestUri [{}]. Get card account list - validation failed: {}", new Object[]{consentId, requestUri, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        SpiResponse<List<SpiCardAccountDetails>> spiResponse = this.getAccountListSpiResponse(aisConsent, consentId);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
            log.info("Consent-ID: [{}]. Get card account list failed: SPI level error msg: [{}]", (Object)consentId, (Object)errorHolder);
            return ResponseObject.builder().fail(new MessageError(errorHolder)).build();
        }
        List<Xs2aCardAccountDetails> accountDetails = this.accountDetailsMapper.mapToXs2aCardAccountDetailsList((List)spiResponse.getPayload());
        CmsResponse<AisConsent> aisConsentUpdated = this.accountReferenceUpdater.updateCardAccountReferences(consentId, aisConsent, accountDetails);
        if (aisConsentUpdated.hasError()) {
            log.info("Consent-ID: [{}]. Get card account list failed: couldn't update account consent access.", (Object)consentId);
            if (CmsError.CHECKSUM_ERROR == aisConsentUpdated.getError()) {
                return ResponseObject.builder().fail(ErrorType.AIS_500, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_VALIDATION_FAILED)).build();
            }
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        this.loggingContextService.storeConsentStatus(aisConsent.getConsentStatus());
        return this.getXs2aAccountListHolderResponseObject(consentId, requestUri, (AisConsent)aisConsentUpdated.getPayload(), accountDetails);
    }

    public ResponseObject<Xs2aCardAccountDetailsHolder> getCardAccountDetails(String consentId, String accountId, String requestUri) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_CARD_ACCOUNT_DETAILS_REQUEST_RECEIVED);
        Optional<AisConsent> aisConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (aisConsentOptional.isEmpty()) {
            log.info("Account-ID [{}], Consent-ID [{}]. Get card account details failed. Account consent not found by ID", (Object)accountId, (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AisConsent aisConsent = aisConsentOptional.get();
        ValidationResult validationResult = this.getCardAccountDetailsValidator.validate(new GetCardAccountDetailsRequestObject(aisConsent, accountId, requestUri));
        if (validationResult.isNotValid()) {
            log.info("Account-ID [{}], Consent-ID [{}], RequestUri [{}]. Get card account details - validation failed: {}", new Object[]{accountId, consentId, requestUri, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        SpiResponse<SpiCardAccountDetails> spiResponse = this.getAccountDetailsSpiResponse(aisConsent, consentId, accountId);
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
            log.info("Account-ID [{}], Consent-ID: [{}]. Get card account details failed: couldn't get account details. Error msg: [{}]", new Object[]{accountId, consentId, errorHolder});
            return ResponseObject.builder().fail(errorHolder).build();
        }
        this.loggingContextService.storeConsentStatus(aisConsent.getConsentStatus());
        return this.getXs2aAccountDetailsHolderResponseObject(consentId, requestUri, aisConsent, (SpiCardAccountDetails)spiResponse.getPayload());
    }

    private SpiResponse<SpiCardAccountDetails> getAccountDetailsSpiResponse(AisConsent aisConsent, String consentId, String accountId) {
        AccountAccess access = aisConsent.getAccess();
        SpiAccountReference requestedAccountReference = aisConsent.isGlobalConsent() ? new SpiAccountReference(accountId, null, null, null, null, null, null, null) : this.accountHelperService.findAccountReference(access.getAccounts(), accountId);
        return this.cardAccountSpi.requestCardAccountDetailsForAccount(this.accountHelperService.getSpiContextData(), requestedAccountReference, this.consentMapper.mapToSpiAccountConsent(aisConsent), this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
    }

    @NotNull
    private ResponseObject<Xs2aCardAccountDetailsHolder> getXs2aAccountDetailsHolderResponseObject(String consentId, String requestUri, AisConsent aisConsent, SpiCardAccountDetails spiAccountDetails) {
        Xs2aCardAccountDetails cardAccountDetails = this.accountDetailsMapper.mapToXs2aCardAccountDetails(spiAccountDetails);
        Xs2aCardAccountDetailsHolder xs2aCardAccountDetailsHolder = new Xs2aCardAccountDetailsHolder(cardAccountDetails, aisConsent);
        ResponseObject<Xs2aCardAccountDetailsHolder> response = ResponseObject.builder().body(xs2aCardAccountDetailsHolder).build();
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), consentId, this.accountHelperService.createActionStatus(false, TypeAccess.ACCOUNT, response), requestUri, this.accountHelperService.needsToUpdateUsage(aisConsent), spiAccountDetails.getResourceId(), null);
        return response;
    }

    private SpiResponse<List<SpiCardAccountDetails>> getAccountListSpiResponse(AisConsent aisConsent, String consentId) {
        return this.cardAccountSpi.requestCardAccountList(this.accountHelperService.getSpiContextData(), this.consentMapper.mapToSpiAccountConsent(aisConsent), this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
    }

    @NotNull
    private ResponseObject<Xs2aCardAccountListHolder> getXs2aAccountListHolderResponseObject(String consentId, String requestUri, AisConsent aisConsent, List<Xs2aCardAccountDetails> accountDetails) {
        Xs2aCardAccountListHolder xs2aCardAccountListHolder = new Xs2aCardAccountListHolder(accountDetails, aisConsent);
        ResponseObject<Xs2aCardAccountListHolder> response = ResponseObject.builder().body(xs2aCardAccountListHolder).build();
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), consentId, this.accountHelperService.createActionStatus(false, TypeAccess.ACCOUNT, response), requestUri, this.accountHelperService.needsToUpdateUsage(aisConsent), null, null);
        return response;
    }

    @ConstructorProperties(value={"cardAccountSpi", "accountDetailsMapper", "aisConsentService", "consentMapper", "tppService", "xs2aEventService", "accountReferenceUpdater", "spiErrorMapper", "getCardAccountListValidator", "getCardAccountDetailsValidator", "aspspConsentDataProviderFactory", "accountHelperService", "loggingContextService"})
    public CardAccountService(CardAccountSpi cardAccountSpi, SpiToXs2aAccountDetailsMapper accountDetailsMapper, Xs2aAisConsentService aisConsentService, Xs2aAisConsentMapper consentMapper, TppService tppService, Xs2aEventService xs2aEventService, AccountReferenceInConsentUpdater accountReferenceUpdater, SpiErrorMapper spiErrorMapper, GetCardAccountListValidator getCardAccountListValidator, GetCardAccountDetailsValidator getCardAccountDetailsValidator, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, AccountHelperService accountHelperService, LoggingContextService loggingContextService) {
        this.cardAccountSpi = cardAccountSpi;
        this.accountDetailsMapper = accountDetailsMapper;
        this.aisConsentService = aisConsentService;
        this.consentMapper = consentMapper;
        this.tppService = tppService;
        this.xs2aEventService = xs2aEventService;
        this.accountReferenceUpdater = accountReferenceUpdater;
        this.spiErrorMapper = spiErrorMapper;
        this.getCardAccountListValidator = getCardAccountListValidator;
        this.getCardAccountDetailsValidator = getCardAccountDetailsValidator;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.accountHelperService = accountHelperService;
        this.loggingContextService = loggingContextService;
    }
}

