/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.ais;

import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.ais.AccountHelperService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBalanceReportMapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.service.validator.ais.account.GetBalancesReportValidator;
import de.adorsys.psd2.xs2a.service.validator.ais.account.dto.GetAccountBalanceRequestObject;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AccountSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BalanceService {
    private static final Logger log = LoggerFactory.getLogger(BalanceService.class);
    private final AccountSpi accountSpi;
    private final SpiToXs2aBalanceReportMapper balanceReportMapper;
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAisConsentMapper consentMapper;
    private final TppService tppService;
    private final Xs2aEventService xs2aEventService;
    private final SpiErrorMapper spiErrorMapper;
    private final GetBalancesReportValidator getBalancesReportValidator;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final AccountHelperService accountHelperService;
    private final LoggingContextService loggingContextService;

    public ResponseObject<Xs2aBalancesReport> getBalancesReport(String consentId, String accountId, String requestUri) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.READ_BALANCE_REQUEST_RECEIVED);
        Optional<AisConsent> aisConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (aisConsentOptional.isEmpty()) {
            log.info("Account-ID [{}], Consent-ID [{}]. Get balances report failed. Account consent not found by ID", (Object)accountId, (Object)consentId);
            return ResponseObject.builder().fail(ErrorType.AIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        AisConsent aisConsent = aisConsentOptional.get();
        ValidationResult validationResult = this.getValidationResultForCommonAccountBalanceRequest(accountId, requestUri, aisConsent);
        if (validationResult.isNotValid()) {
            log.info("Account-ID [{}], Consent-ID [{}], RequestUri [{}]. Get balances report - validation failed: {}", new Object[]{accountId, consentId, requestUri, validationResult.getMessageError()});
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        SpiResponse<List<SpiAccountBalance>> spiResponse = this.getSpiResponse(aisConsent, consentId, accountId);
        if (spiResponse.hasError()) {
            return this.checkSpiResponse(consentId, accountId, spiResponse);
        }
        this.loggingContextService.storeConsentStatus(aisConsent.getConsentStatus());
        return this.getXs2aBalancesReportResponseObject(aisConsent, accountId, consentId, requestUri, (List)spiResponse.getPayload());
    }

    private ValidationResult getValidationResultForCommonAccountBalanceRequest(String accountId, String requestUri, AisConsent accountConsent) {
        return this.getBalancesReportValidator.validate(new GetAccountBalanceRequestObject(accountConsent, accountId, requestUri));
    }

    private SpiResponse<List<SpiAccountBalance>> getSpiResponse(AisConsent aisConsent, String consentId, String accountId) {
        AccountAccess access = aisConsent.getAspspAccountAccesses();
        SpiAccountReference requestedAccountReference = this.accountHelperService.findAccountReference(access.getBalances(), accountId);
        return this.accountSpi.requestBalancesForAccount(this.accountHelperService.getSpiContextData(), requestedAccountReference, this.consentMapper.mapToSpiAccountConsent(aisConsent), this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
    }

    private ResponseObject<Xs2aBalancesReport> checkSpiResponse(String consentId, String accountId, SpiResponse<List<SpiAccountBalance>> spiResponse) {
        log.info("Account-ID [{}], Consent-ID: [{}]. Get balances report failed: error on SPI level", (Object)accountId, (Object)consentId);
        return ResponseObject.builder().fail(new MessageError(this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS))).build();
    }

    @NotNull
    private ResponseObject<Xs2aBalancesReport> getXs2aBalancesReportResponseObject(AisConsent accountConsent, String accountId, String consentId, String requestUri, List<SpiAccountBalance> payload) {
        AccountAccess access = accountConsent.getAspspAccountAccesses();
        List balances = access.getBalances();
        if (this.hasNoAccessToSource(balances)) {
            return ResponseObject.builder().fail(ErrorType.AIS_401, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_INVALID)).build();
        }
        SpiAccountReference requestedAccountReference = this.accountHelperService.findAccountReference(balances, accountId);
        Xs2aBalancesReport balancesReport = this.balanceReportMapper.mapToXs2aBalancesReportSpi(requestedAccountReference, payload);
        ResponseObject<Xs2aBalancesReport> response = ResponseObject.builder().body(balancesReport).build();
        this.aisConsentService.consentActionLog(this.tppService.getTppId(), consentId, this.accountHelperService.createActionStatus(false, TypeAccess.BALANCE, response), requestUri, this.accountHelperService.needsToUpdateUsage(accountConsent), accountId, null);
        return response;
    }

    private boolean hasNoAccessToSource(List<AccountReference> references) {
        return references.stream().allMatch(AccountReference::isNotIbanAccount);
    }

    @ConstructorProperties(value={"accountSpi", "balanceReportMapper", "aisConsentService", "consentMapper", "tppService", "xs2aEventService", "spiErrorMapper", "getBalancesReportValidator", "aspspConsentDataProviderFactory", "accountHelperService", "loggingContextService"})
    public BalanceService(AccountSpi accountSpi, SpiToXs2aBalanceReportMapper balanceReportMapper, Xs2aAisConsentService aisConsentService, Xs2aAisConsentMapper consentMapper, TppService tppService, Xs2aEventService xs2aEventService, SpiErrorMapper spiErrorMapper, GetBalancesReportValidator getBalancesReportValidator, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, AccountHelperService accountHelperService, LoggingContextService loggingContextService) {
        this.accountSpi = accountSpi;
        this.balanceReportMapper = balanceReportMapper;
        this.aisConsentService = aisConsentService;
        this.consentMapper = consentMapper;
        this.tppService = tppService;
        this.xs2aEventService = xs2aEventService;
        this.spiErrorMapper = spiErrorMapper;
        this.getBalancesReportValidator = getBalancesReportValidator;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.accountHelperService = accountHelperService;
        this.loggingContextService = loggingContextService;
    }
}

