package de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers;

import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.core.mapper.ConsentDataMapper;
import de.adorsys.psd2.xs2a.core.authorisation.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-09-07T11:47:11+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.12 (Azul Systems, Inc.)"
)
@Component
public class Xs2aPiisConsentMapperImpl extends Xs2aPiisConsentMapper {

    @Autowired
    private ConsentDataMapper consentDataMapper;

    @Override
    public PiisConsent mapToPiisConsent(CmsConsent cmsConsent) {
        if ( cmsConsent == null ) {
            return null;
        }

        PiisConsent piisConsent = new PiisConsent();

        piisConsent.setConsentTppInformation( cmsConsent.getTppInformation() );
        piisConsent.setConsentData( consentDataMapper.mapToPiisConsentData( cmsConsent.getConsentData() ) );
        piisConsent.setId( cmsConsent.getId() );
        piisConsent.setInternalRequestId( cmsConsent.getInternalRequestId() );
        piisConsent.setConsentStatus( cmsConsent.getConsentStatus() );
        piisConsent.setFrequencyPerDay( cmsConsent.getFrequencyPerDay() );
        piisConsent.setRecurringIndicator( cmsConsent.isRecurringIndicator() );
        piisConsent.setMultilevelScaRequired( cmsConsent.isMultilevelScaRequired() );
        piisConsent.setValidUntil( cmsConsent.getValidUntil() );
        piisConsent.setExpireDate( cmsConsent.getExpireDate() );
        piisConsent.setLastActionDate( cmsConsent.getLastActionDate() );
        piisConsent.setCreationTimestamp( cmsConsent.getCreationTimestamp() );
        piisConsent.setStatusChangeTimestamp( cmsConsent.getStatusChangeTimestamp() );
        piisConsent.setAuthorisationTemplate( cmsConsent.getAuthorisationTemplate() );
        List<PsuIdData> list = cmsConsent.getPsuIdDataList();
        if ( list != null ) {
            piisConsent.setPsuIdDataList( new ArrayList<PsuIdData>( list ) );
        }
        piisConsent.setAuthorisations( authorisationListToAccountConsentAuthorizationList( cmsConsent.getAuthorisations() ) );
        Map<String, Integer> map = cmsConsent.getUsages();
        if ( map != null ) {
            piisConsent.setUsages( new HashMap<String, Integer>( map ) );
        }
        piisConsent.setTppAccountAccesses( cmsConsent.getTppAccountAccesses() );
        piisConsent.setAspspAccountAccesses( cmsConsent.getAspspAccountAccesses() );
        piisConsent.setInstanceId( cmsConsent.getInstanceId() );

        return piisConsent;
    }

    protected AccountConsentAuthorization authorisationToAccountConsentAuthorization(Authorisation authorisation) {
        if ( authorisation == null ) {
            return null;
        }

        AccountConsentAuthorization accountConsentAuthorization = new AccountConsentAuthorization();

        accountConsentAuthorization.setPsuIdData( authorisation.getPsuIdData() );
        accountConsentAuthorization.setScaStatus( authorisation.getScaStatus() );
        accountConsentAuthorization.setPassword( authorisation.getPassword() );
        accountConsentAuthorization.setChosenScaApproach( authorisation.getChosenScaApproach() );
        accountConsentAuthorization.setAuthenticationMethodId( authorisation.getAuthenticationMethodId() );
        accountConsentAuthorization.setScaAuthenticationData( authorisation.getScaAuthenticationData() );

        return accountConsentAuthorization;
    }

    protected List<AccountConsentAuthorization> authorisationListToAccountConsentAuthorizationList(List<Authorisation> list) {
        if ( list == null ) {
            return null;
        }

        List<AccountConsentAuthorization> list1 = new ArrayList<AccountConsentAuthorization>( list.size() );
        for ( Authorisation authorisation : list ) {
            list1.add( authorisationToAccountConsentAuthorization( authorisation ) );
        }

        return list1;
    }
}
