/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.piis;

import de.adorsys.psd2.core.data.Consent;
import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.fund.PiisConsentValidationResult;
import de.adorsys.psd2.xs2a.service.TppService;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PiisConsentValidation {
    private static final Logger log = LoggerFactory.getLogger(PiisConsentValidation.class);
    private final TppService tppService;

    public PiisConsentValidationResult validatePiisConsentData(List<PiisConsent> piisConsents) {
        if (CollectionUtils.isEmpty(piisConsents)) {
            return new PiisConsentValidationResult(ErrorHolder.builder((ErrorType)ErrorType.PIIS_400).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.NO_PIIS_ACTIVATION)}).build());
        }
        Optional<PiisConsent> filteredPiisConsent = piisConsents.stream().filter(e -> EnumSet.of(ConsentStatus.VALID, ConsentStatus.RECEIVED).contains(e.getConsentStatus())).filter(this::isNotExpired).filter(this::filterByTpp).sorted(Comparator.comparing(Consent::getCreationTimestamp, Comparator.nullsLast(Comparator.reverseOrder()))).findAny();
        return filteredPiisConsent.map(PiisConsentValidationResult::new).orElseGet(() -> new PiisConsentValidationResult(ErrorHolder.builder((ErrorType)ErrorType.PIIS_400).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_400)}).build()));
    }

    private boolean isNotExpired(PiisConsent consent) {
        return Optional.ofNullable(consent.getValidUntil()).map(d -> d.compareTo(LocalDate.now()) >= 0).orElse(true);
    }

    private boolean filterByTpp(PiisConsent piisConsent) {
        return Optional.of(piisConsent).map(Consent::getTppInfo).map(tpp -> tpp.getAuthorisationNumber().equals(this.tppService.getTppInfo().getAuthorisationNumber())).orElse(true);
    }

    @ConstructorProperties(value={"tppService"})
    public PiisConsentValidation(TppService tppService) {
        this.tppService = tppService;
    }
}

