/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.validator.ValidationGroup;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ValueValidatorService {
    private static final Logger log = LoggerFactory.getLogger(ValueValidatorService.class);
    private Validator validator;

    @Autowired
    public ValueValidatorService(Validator validator) {
        this.validator = validator;
    }

    public void validateAccountIdTransactionId(String accountId, String transactionId) {
        ValidationGroup fieldValidator = new ValidationGroup();
        fieldValidator.setAccountId(accountId);
        fieldValidator.setTransactionId(transactionId);
        this.validate(fieldValidator, ValidationGroup.AccountIdAndTransactionIdIsValid.class);
    }

    public void validate(Object obj, Class<?> ... groups) {
        List violations = this.validator.validate(obj, (Class[])groups).stream().map(vl -> vl.getPropertyPath().toString() + " : " + vl.getMessage()).collect(Collectors.toList());
        if (!violations.isEmpty()) {
            log.debug("Value validation failed: {}", (Object)violations.toString());
            throw new ValidationException(MessageErrorCode.FORMAT_ERROR.name() + ": " + violations);
        }
    }
}

