/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.AuthorisationServiceEncrypted;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.EndpointAccessChecker;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class PisEndpointAccessCheckerService
extends EndpointAccessChecker {
    private final AuthorisationServiceEncrypted authorisationServiceEncrypted;
    private final AspspProfileServiceWrapper aspspProfileService;

    public boolean isEndpointAccessible(String authorisationId, boolean confirmationCodeReceived) {
        boolean confirmationCodeCase = confirmationCodeReceived && this.aspspProfileService.isAuthorisationConfirmationRequestMandated();
        CmsResponse authorisationResponse = this.authorisationServiceEncrypted.getAuthorisationById(authorisationId);
        return Optional.ofNullable(authorisationResponse).map(CmsResponse::getPayload).map(p -> this.isAccessible(p.getChosenScaApproach(), p.getScaStatus(), confirmationCodeCase)).orElse(true);
    }

    @ConstructorProperties(value={"authorisationServiceEncrypted", "aspspProfileService"})
    public PisEndpointAccessCheckerService(AuthorisationServiceEncrypted authorisationServiceEncrypted, AspspProfileServiceWrapper aspspProfileService) {
        this.authorisationServiceEncrypted = authorisationServiceEncrypted;
        this.aspspProfileService = aspspProfileService;
    }
}

