/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.spi;

import de.adorsys.psd2.consent.api.AspspDataService;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpiAspspConsentDataProviderImpl
implements SpiAspspConsentDataProvider {
    private final String encryptedConsentId;
    private final AspspDataService aspspDataService;
    private byte[] lastKnownData = ArrayUtils.EMPTY_BYTE_ARRAY;

    @NotNull
    public byte[] loadAspspConsentData() {
        byte[] readData = this.aspspDataService.readAspspConsentData(this.encryptedConsentId).map(AspspConsentData::getAspspConsentData).orElse(ArrayUtils.EMPTY_BYTE_ARRAY);
        this.lastKnownData = readData;
        return readData;
    }

    public void updateAspspConsentData(@Nullable byte[] aspspConsentData) {
        if (Arrays.equals(ArrayUtils.nullToEmpty((byte[])aspspConsentData), this.lastKnownData)) {
            return;
        }
        if (aspspConsentData == null || Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, aspspConsentData)) {
            this.clearAspspConsentData();
            return;
        }
        this.aspspDataService.updateAspspConsentData(new AspspConsentData(aspspConsentData, this.encryptedConsentId));
        this.lastKnownData = aspspConsentData;
    }

    public void clearAspspConsentData() {
        this.aspspDataService.deleteAspspConsentData(this.encryptedConsentId);
        this.lastKnownData = ArrayUtils.EMPTY_BYTE_ARRAY;
    }

    @ConstructorProperties(value={"encryptedConsentId", "aspspDataService"})
    SpiAspspConsentDataProviderImpl(String encryptedConsentId, AspspDataService aspspDataService) {
        this.encryptedConsentId = encryptedConsentId;
        this.aspspDataService = aspspDataService;
    }
}

