/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.api.consent.CmsCreateConsentResponse;
import de.adorsys.psd2.consent.api.service.AisConsentServiceEncrypted;
import de.adorsys.psd2.consent.api.service.ConsentServiceEncrypted;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCreatePiisConsentResponse;
import de.adorsys.psd2.xs2a.domain.fund.CreatePiisConsentRequest;
import de.adorsys.psd2.xs2a.service.mapper.cms_xs2a_mappers.Xs2aPiisConsentMapper;
import de.adorsys.psd2.xs2a.service.profile.FrequencyPerDateCalculationService;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Xs2aPiisConsentService {
    private static final Logger log = LoggerFactory.getLogger(Xs2aPiisConsentService.class);
    private final ConsentServiceEncrypted consentService;
    private final Xs2aPiisConsentMapper xs2aPiisConsentMapper;
    private final FrequencyPerDateCalculationService frequencyPerDateCalculationService;
    private final AisConsentServiceEncrypted aisConsentService;

    public Optional<Xs2aCreatePiisConsentResponse> createConsent(CreatePiisConsentRequest request, PsuIdData psuData, TppInfo tppInfo) {
        CmsResponse response;
        int allowedFrequencyPerDay = this.frequencyPerDateCalculationService.getMinFrequencyPerDay(Integer.MAX_VALUE);
        CmsConsent cmsConsent = this.xs2aPiisConsentMapper.mapToCmsConsent(request, psuData, tppInfo, allowedFrequencyPerDay);
        try {
            response = this.consentService.createConsent(cmsConsent);
        }
        catch (WrongChecksumException e) {
            log.info("Consent cannot be created, checksum verification failed");
            return Optional.empty();
        }
        if (response.hasError()) {
            log.info("Consent cannot be created, because can't save to cms DB");
            return Optional.empty();
        }
        CmsCreateConsentResponse createConsentResponse = (CmsCreateConsentResponse)response.getPayload();
        PiisConsent piisConsent = this.xs2aPiisConsentMapper.mapToPiisConsent(createConsentResponse.getCmsConsent());
        Xs2aCreatePiisConsentResponse xs2aCreatePiisConsentResponse = new Xs2aCreatePiisConsentResponse(createConsentResponse.getConsentId(), piisConsent);
        return Optional.of(xs2aCreatePiisConsentResponse);
    }

    public Optional<PiisConsent> getPiisConsentById(String consentId) {
        CmsResponse consentById = this.consentService.getConsentById(consentId);
        if (consentById.hasError()) {
            log.info("Get consent by id failed due to CMS problems");
            return Optional.empty();
        }
        PiisConsent piisConsent = this.xs2aPiisConsentMapper.mapToPiisConsent((CmsConsent)consentById.getPayload());
        return Optional.ofNullable(piisConsent);
    }

    public void updateConsentStatus(String consentId, ConsentStatus consentStatus) {
        try {
            this.consentService.updateConsentStatusById(consentId, consentStatus);
        }
        catch (WrongChecksumException e) {
            log.info("updateConsentStatus cannot be executed, checksum verification failed");
        }
    }

    public CmsResponse<PiisConsent> updateAspspAccountAccess(String consentId, AccountAccess accountAccess) {
        CmsResponse response;
        CmsResponse.CmsResponseBuilder builder = CmsResponse.builder();
        try {
            response = this.aisConsentService.updateAspspAccountAccess(consentId, accountAccess);
        }
        catch (WrongChecksumException e) {
            return builder.error(CmsError.CHECKSUM_ERROR).build();
        }
        if (response.hasError()) {
            return builder.error(response.getError()).build();
        }
        return builder.payload((Object)this.xs2aPiisConsentMapper.mapToPiisConsent((CmsConsent)response.getPayload())).build();
    }

    @ConstructorProperties(value={"consentService", "xs2aPiisConsentMapper", "frequencyPerDateCalculationService", "aisConsentService"})
    public Xs2aPiisConsentService(ConsentServiceEncrypted consentService, Xs2aPiisConsentMapper xs2aPiisConsentMapper, FrequencyPerDateCalculationService frequencyPerDateCalculationService, AisConsentServiceEncrypted aisConsentService) {
        this.consentService = consentService;
        this.xs2aPiisConsentMapper = xs2aPiisConsentMapper;
        this.frequencyPerDateCalculationService = frequencyPerDateCalculationService;
        this.aisConsentService = aisConsentService;
    }
}

