/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.component.logger;

import de.adorsys.psd2.xs2a.component.logger.TppLogType;
import de.adorsys.psd2.xs2a.component.logger.TppLogger;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.Nullable;

public class TppResponseLogBuilder
extends TppLogger.TppLogBuilder<TppResponseLogBuilder> {
    private static final String TPP_ID = "TPP ID";
    private static final String RESPONSE_STATUS = "Status";
    private static final String REDIRECT_ID = "Redirect-ID";
    private HttpServletResponse response;

    TppResponseLogBuilder(HttpServletResponse httpServletResponse) {
        super(TppLogType.RESPONSE);
        this.response = httpServletResponse;
    }

    public TppResponseLogBuilder withTpp(TppInfo tppInfo) {
        this.putLogParameter(TPP_ID, tppInfo.getAuthorisationNumber());
        return this;
    }

    public TppResponseLogBuilder withResponseStatus() {
        this.putLogParameter(RESPONSE_STATUS, String.valueOf(this.response.getStatus()));
        return this;
    }

    public TppResponseLogBuilder withOptionalRedirectId(@Nullable String redirectId) {
        if (redirectId != null) {
            this.putLogParameter(REDIRECT_ID, redirectId);
        }
        return this;
    }

    @Override
    protected TppResponseLogBuilder getThis() {
        return this;
    }
}

