/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.payment.handler;

import de.adorsys.psd2.validator.payment.PaymentBodyFieldsValidator;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.web.validator.body.payment.handler.config.DefaultPaymentValidationConfigImpl;
import de.adorsys.psd2.xs2a.web.validator.body.payment.handler.config.PaymentValidationConfig;
import de.adorsys.psd2.xs2a.web.validator.body.payment.handler.type.PaymentTypeValidator;
import de.adorsys.psd2.xs2a.web.validator.body.payment.handler.type.PaymentTypeValidatorContext;
import de.adorsys.psd2.xs2a.web.validator.body.raw.FieldExtractor;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Primary
@Component
public class DefaultPaymentBodyFieldsValidatorImpl
implements PaymentBodyFieldsValidator {
    private PaymentTypeValidatorContext paymentTypeValidatorContext;
    private FieldExtractor fieldExtractor;
    private PaymentValidationConfig validationConfig;

    @Autowired
    public DefaultPaymentBodyFieldsValidatorImpl(PaymentTypeValidatorContext paymentTypeValidatorContext, FieldExtractor fieldExtractor) {
        this.paymentTypeValidatorContext = paymentTypeValidatorContext;
        this.fieldExtractor = fieldExtractor;
        this.validationConfig = this.createPaymentValidationConfig();
    }

    public MessageError validate(HttpServletRequest request, String paymentService, MessageError messageError) {
        Optional<Object> bodyOptional = this.fieldExtractor.mapBodyToInstance(request, messageError, Object.class);
        if (!bodyOptional.isPresent()) {
            return messageError;
        }
        Optional<PaymentTypeValidator> validator = this.paymentTypeValidatorContext.getValidator(paymentService);
        if (!validator.isPresent()) {
            throw new IllegalArgumentException("Unsupported payment service");
        }
        return validator.get().validate(bodyOptional.get(), messageError, this.validationConfig);
    }

    public DefaultPaymentValidationConfigImpl createPaymentValidationConfig() {
        return new DefaultPaymentValidationConfigImpl();
    }
}

