/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body.consent;

import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.model.AccountAccess;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.AdditionalInformationAccess;
import de.adorsys.psd2.model.Consents;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.body.AbstractBodyValidatorImpl;
import de.adorsys.psd2.xs2a.web.validator.body.AccountReferenceValidator;
import de.adorsys.psd2.xs2a.web.validator.body.DateFieldValidator;
import de.adorsys.psd2.xs2a.web.validator.body.consent.ConsentBodyValidator;
import de.adorsys.psd2.xs2a.web.validator.body.raw.FieldExtractor;
import de.adorsys.psd2.xs2a.web.validator.constants.Xs2aRequestBodyDateFields;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccountAccessValidatorImpl
extends AbstractBodyValidatorImpl
implements ConsentBodyValidator {
    private AccountReferenceValidator accountReferenceValidator;
    private DateFieldValidator dateFieldValidator;
    private FieldExtractor fieldExtractor;

    @Autowired
    public AccountAccessValidatorImpl(ErrorBuildingService errorBuildingService, Xs2aObjectMapper xs2aObjectMapper, AccountReferenceValidator accountReferenceValidator, DateFieldValidator dateFieldValidator, FieldExtractor fieldExtractor) {
        super(errorBuildingService, xs2aObjectMapper);
        this.accountReferenceValidator = accountReferenceValidator;
        this.dateFieldValidator = dateFieldValidator;
        this.fieldExtractor = fieldExtractor;
    }

    @Override
    public MessageError validateBodyFields(HttpServletRequest request, MessageError messageError) {
        Optional<Consents> consentsOptional = this.fieldExtractor.mapBodyToInstance(request, messageError, Consents.class);
        if (!consentsOptional.isPresent()) {
            return messageError;
        }
        Consents consents = consentsOptional.get();
        if (consents.getAccess() == null) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_NULL_VALUE, (Object[])new Object[]{"access"}));
        } else {
            this.validateAccountAccess(consents, messageError);
        }
        return messageError;
    }

    @Override
    public MessageError validateRawData(HttpServletRequest request, MessageError messageError) {
        return this.dateFieldValidator.validateDateFormat(request, Xs2aRequestBodyDateFields.AIS_CONSENT_DATE_FIELDS.getDateFields(), messageError);
    }

    private void validateAccountAccess(Consents consents, MessageError messageError) {
        de.adorsys.psd2.model.AccountAccess accountAccess = consents.getAccess();
        if (accountAccess.getAccounts() != null) {
            CreateConsentReq createConsent;
            Stream allReferences = Stream.of(accountAccess.getAccounts(), accountAccess.getBalances(), accountAccess.getTransactions()).filter(Objects::nonNull).flatMap(Collection::stream);
            Stream additionalReferences = Optional.ofNullable(accountAccess.getAdditionalInformation()).map(additionalInformationAccess -> Stream.of(additionalInformationAccess.getOwnerName(), additionalInformationAccess.getTrustedBeneficiaries()).filter(Objects::nonNull).flatMap(Collection::stream)).orElseGet(Stream::empty);
            List<AccountReference> allReferencesList = allReferences.collect(Collectors.toList());
            List<AccountReference> additionalReferencesList = additionalReferences.collect(Collectors.toList());
            Stream.of(allReferencesList, additionalReferencesList).flatMap(Collection::stream).distinct().forEach(ar -> this.accountReferenceValidator.validate((AccountReference)ar, messageError));
            if (this.areAdditionalReferencesIncorrect(additionalReferencesList, allReferencesList)) {
                this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.SERVICE_INVALID_400));
            }
            if (this.areFlagsAndAccountsInvalid(createConsent = this.mapToCreateConsentReq(consents, messageError))) {
                this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_CONSENT_INCORRECT));
            }
        }
    }

    private boolean areAdditionalReferencesIncorrect(List<AccountReference> additionalReferencesList, List<AccountReference> allReferencesList) {
        if (CollectionUtils.isEmpty(additionalReferencesList)) {
            return false;
        }
        return !additionalReferencesList.stream().allMatch(allReferencesList::contains);
    }

    private boolean areFlagsAndAccountsInvalid(CreateConsentReq request) {
        AccountAccess access = request.getAccess();
        if (access.isNotEmpty(request.getAisConsentData())) {
            return !CollectionUtils.isEmpty(request.getAccountReferences()) && !this.areFlagsEmpty(request);
        }
        return false;
    }

    private boolean areFlagsEmpty(CreateConsentReq createConsentReq) {
        return Objects.isNull(createConsentReq.getAvailableAccounts()) && Objects.isNull(createConsentReq.getAllPsd2());
    }

    private CreateConsentReq mapToCreateConsentReq(Consents consent, MessageError messageError) {
        return Optional.ofNullable(consent).map(cnst -> {
            CreateConsentReq createAisConsentRequest = new CreateConsentReq();
            createAisConsentRequest.setAccess(this.mapToAccountAccessInner(cnst.getAccess(), messageError));
            createAisConsentRequest.setAvailableAccounts(this.mapToAccountAccessTypeFromAvailableAccounts(cnst.getAccess().getAvailableAccounts()));
            createAisConsentRequest.setAvailableAccountsWithBalance(this.mapToAccountAccessTypeFromAvailableAccountsWithBalance(cnst.getAccess().getAvailableAccountsWithBalance()));
            createAisConsentRequest.setAllPsd2(this.mapToAccountAccessTypeFromAllPsd2Enum(cnst.getAccess().getAllPsd2()));
            return createAisConsentRequest;
        }).orElse(null);
    }

    private AccountAccess mapToAccountAccessInner(de.adorsys.psd2.model.AccountAccess accountAccess, MessageError messageError) {
        return Optional.ofNullable(accountAccess).map(acs -> new AccountAccess(this.mapToXs2aAccountReferences(acs.getAccounts(), messageError), this.mapToXs2aAccountReferences(acs.getBalances(), messageError), this.mapToXs2aAccountReferences(acs.getTransactions(), messageError), this.mapToAdditionalInformationAccess(acs.getAdditionalInformation(), messageError))).orElse(null);
    }

    private de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess mapToAdditionalInformationAccess(AdditionalInformationAccess additionalInformationAccess, MessageError messageError) {
        if (additionalInformationAccess == null) {
            return null;
        }
        return new de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess(this.mapToXs2aAccountReferences(additionalInformationAccess.getOwnerName(), messageError), this.mapToXs2aAccountReferences(additionalInformationAccess.getTrustedBeneficiaries(), messageError));
    }

    private List<de.adorsys.psd2.xs2a.core.profile.AccountReference> mapToXs2aAccountReferences(List<AccountReference> references, MessageError messageError) {
        return Optional.ofNullable(references).map(ref -> ref.stream().map(reference -> this.mapToAccountReference(reference, messageError)).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    private AccountAccessType mapToAccountAccessTypeFromAvailableAccounts(AccountAccess.AvailableAccountsEnum accountsEnum) {
        return Optional.ofNullable(accountsEnum).flatMap(en -> AccountAccessType.getByDescription((String)en.toString())).orElse(null);
    }

    private AccountAccessType mapToAccountAccessTypeFromAllPsd2Enum(AccountAccess.AllPsd2Enum allPsd2Enum) {
        return Optional.ofNullable(allPsd2Enum).flatMap(en -> AccountAccessType.getByDescription((String)en.toString())).orElse(null);
    }

    private AccountAccessType mapToAccountAccessTypeFromAvailableAccountsWithBalance(AccountAccess.AvailableAccountsWithBalanceEnum accountsEnum) {
        return Optional.ofNullable(accountsEnum).flatMap(en -> AccountAccessType.getByDescription((String)en.toString())).orElse(null);
    }

    private de.adorsys.psd2.xs2a.core.profile.AccountReference mapToAccountReference(Object reference, MessageError messageError) {
        try {
            return (de.adorsys.psd2.xs2a.core.profile.AccountReference)this.xs2aObjectMapper.convertValue(reference, de.adorsys.psd2.xs2a.core.profile.AccountReference.class);
        }
        catch (IllegalArgumentException e) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_WRONG_FORMAT_VALUE, (Object[])new Object[]{"currency"}));
            return null;
        }
    }
}

