/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import de.adorsys.psd2.xs2a.web.validator.ObjectValidator;
import de.adorsys.psd2.xs2a.web.validator.body.StringMaxLengthValidator;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class RequiredFieldMaxLengthValidator
implements ObjectValidator<StringMaxLengthValidator.MaxLengthRequirement> {
    private final StringMaxLengthValidator stringMaxLengthValidator;
    private final ErrorBuildingService errorBuildingService;

    @Override
    public void validate(@NotNull StringMaxLengthValidator.MaxLengthRequirement object, @NotNull MessageError messageError) {
        if (StringUtils.isBlank((CharSequence)object.getField())) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_EMPTY_FIELD, (Object[])new Object[]{object.getFieldName()}));
        } else {
            this.stringMaxLengthValidator.validate(object, messageError);
        }
    }

    @ConstructorProperties(value={"stringMaxLengthValidator", "errorBuildingService"})
    public RequiredFieldMaxLengthValidator(StringMaxLengthValidator stringMaxLengthValidator, ErrorBuildingService errorBuildingService) {
        this.stringMaxLengthValidator = stringMaxLengthValidator;
        this.errorBuildingService = errorBuildingService;
    }
}

