/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponseType;
import de.adorsys.psd2.xs2a.domain.authorisation.CancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationRequest;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisCancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.RedirectIdService;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.RedirectLinkBuilder;
import de.adorsys.psd2.xs2a.web.aspect.AbstractLinkAspect;
import de.adorsys.psd2.xs2a.web.controller.PaymentController;
import de.adorsys.psd2.xs2a.web.link.PisAuthorisationCancellationLinks;
import de.adorsys.psd2.xs2a.web.link.UpdatePisCancellationPsuDataLinks;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CreatePisAuthorisationCancellationAspect
extends AbstractLinkAspect<PaymentController> {
    private static final Logger log = LoggerFactory.getLogger(CreatePisAuthorisationCancellationAspect.class);
    private final ScaApproachResolver scaApproachResolver;
    private final RedirectLinkBuilder redirectLinkBuilder;
    private final RedirectIdService redirectIdService;
    private RequestProviderService requestProviderService;

    public CreatePisAuthorisationCancellationAspect(ScaApproachResolver scaApproachResolver, RedirectLinkBuilder redirectLinkBuilder, AspspProfileServiceWrapper aspspProfileServiceWrapper, RedirectIdService redirectIdService, RequestProviderService requestProviderService) {
        super(aspspProfileServiceWrapper);
        this.scaApproachResolver = scaApproachResolver;
        this.redirectLinkBuilder = redirectLinkBuilder;
        this.redirectIdService = redirectIdService;
        this.requestProviderService = requestProviderService;
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.PaymentCancellationAuthorisationService.createPisCancellationAuthorisation(..)) && args(request)", returning="result", argNames="result,request")
    public ResponseObject<CancellationAuthorisationResponse> createPisAuthorisationAspect(ResponseObject<CancellationAuthorisationResponse> result, Xs2aCreatePisAuthorisationRequest request) {
        if (!result.hasError()) {
            CancellationAuthorisationResponse body = result.getBody();
            AuthorisationResponseType authorisationResponseType = body.getAuthorisationResponseType();
            if (authorisationResponseType == AuthorisationResponseType.START) {
                Xs2aCreatePisCancellationAuthorisationResponse response = (Xs2aCreatePisCancellationAuthorisationResponse)result.getBody();
                response.setLinks(new PisAuthorisationCancellationLinks(this.getHttpUrl(), this.scaApproachResolver, this.redirectLinkBuilder, this.redirectIdService, request.getPaymentService().getValue(), request.getPaymentProduct(), request.getPaymentId(), body.getAuthorisationId(), this.getScaRedirectFlow(), body.getInternalRequestId(), this.requestProviderService.getInstanceId()));
            } else if (authorisationResponseType == AuthorisationResponseType.UPDATE) {
                Xs2aUpdatePisCommonPaymentPsuDataResponse response = (Xs2aUpdatePisCommonPaymentPsuDataResponse)result.getBody();
                Xs2aUpdatePisCommonPaymentPsuDataRequest updateRequest = this.buildXs2aUpdatePisCommonPaymentPsuDataRequest(request.getPaymentId(), response.getAuthorisationId(), request.getPsuData(), request.getPaymentProduct(), request.getPaymentService(), request.getPassword());
                response.setLinks(new UpdatePisCancellationPsuDataLinks(this.getHttpUrl(), this.scaApproachResolver, updateRequest, body.getScaStatus(), response.getChosenScaMethod()));
            } else {
                throw new IllegalArgumentException("Unknown authorisation response type: " + authorisationResponseType);
            }
        }
        return result;
    }

    private Xs2aUpdatePisCommonPaymentPsuDataRequest buildXs2aUpdatePisCommonPaymentPsuDataRequest(String paymentId, String authorisationId, PsuIdData psuIdData, String paymentProduct, PaymentType paymentService, String password) {
        Xs2aUpdatePisCommonPaymentPsuDataRequest updateRequest = new Xs2aUpdatePisCommonPaymentPsuDataRequest();
        updateRequest.setPaymentId(paymentId);
        updateRequest.setAuthorisationId(authorisationId);
        updateRequest.setPsuData(psuIdData);
        updateRequest.setPassword(password);
        updateRequest.setPaymentProduct(paymentProduct);
        updateRequest.setPaymentService(paymentService);
        return updateRequest;
    }
}

