/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.payment.raw;

import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.model.BulkPaymentInitiationJson;
import de.adorsys.psd2.model.PaymentInitiationJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationJson;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.AccountReferenceCollector;
import de.adorsys.psd2.xs2a.service.mapper.PaymentModelMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PaymentAccountReferenceExtractor {
    private static final Logger log = LoggerFactory.getLogger(PaymentAccountReferenceExtractor.class);
    private final Xs2aObjectMapper xs2aObjectMapper;
    private final PaymentModelMapper paymentModelMapper;

    public Set<AccountReference> extractAccountReferences(byte[] paymentBody, PaymentType paymentType) {
        Optional<AccountReferenceCollector> accountReferenceCollector = this.mapToAccountReferenceCollector(paymentBody, paymentType);
        return accountReferenceCollector.map(AccountReferenceCollector::getAccountReferences).orElse(Collections.emptySet());
    }

    private Optional<AccountReferenceCollector> mapToAccountReferenceCollector(byte[] paymentBody, PaymentType paymentType) {
        try {
            switch (paymentType) {
                case SINGLE: {
                    PaymentInitiationJson paymentInitiationJson = (PaymentInitiationJson)this.xs2aObjectMapper.readValue(paymentBody, PaymentInitiationJson.class);
                    return Optional.ofNullable(this.paymentModelMapper.mapToXs2aPayment(paymentInitiationJson));
                }
                case PERIODIC: {
                    PeriodicPaymentInitiationJson periodicPaymentInitiationJson = (PeriodicPaymentInitiationJson)this.xs2aObjectMapper.readValue(paymentBody, PeriodicPaymentInitiationJson.class);
                    return Optional.ofNullable(this.paymentModelMapper.mapToXs2aPayment(periodicPaymentInitiationJson));
                }
                case BULK: {
                    BulkPaymentInitiationJson bulkPaymentInitiationJson = (BulkPaymentInitiationJson)this.xs2aObjectMapper.readValue(paymentBody, BulkPaymentInitiationJson.class);
                    return Optional.ofNullable(this.paymentModelMapper.mapToXs2aPayment(bulkPaymentInitiationJson));
                }
            }
            throw new IllegalArgumentException("Unknown payment type: " + paymentType);
        }
        catch (IOException ioe) {
            log.info("Couldn't parse payment with paymentType {} from payment body {}", (Object)paymentType, (Object)paymentBody);
            return Optional.empty();
        }
    }

    @ConstructorProperties(value={"xs2aObjectMapper", "paymentModelMapper"})
    public PaymentAccountReferenceExtractor(Xs2aObjectMapper xs2aObjectMapper, PaymentModelMapper paymentModelMapper) {
        this.xs2aObjectMapper = xs2aObjectMapper;
        this.paymentModelMapper = paymentModelMapper;
    }
}

