/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.create;

import de.adorsys.psd2.consent.api.pis.CreatePisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPisCommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodDecider;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationServiceResolver;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisCommonPaymentService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aPisCommonPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aToCmsPisCommonPaymentRequestMapper;
import de.adorsys.psd2.xs2a.service.payment.create.CreatePaymentService;
import de.adorsys.psd2.xs2a.service.payment.create.PisPaymentInfoCreationObject;
import de.adorsys.psd2.xs2a.service.payment.create.spi.PaymentInitiationService;
import de.adorsys.psd2.xs2a.service.spi.InitialSpiAspspConsentDataProvider;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCreatePaymentService<P extends CommonPayment, S extends PaymentInitiationService<P>>
implements CreatePaymentService {
    protected final Xs2aPisCommonPaymentService pisCommonPaymentService;
    private final PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver;
    private final AuthorisationMethodDecider authorisationMethodDecider;
    private final Xs2aPisCommonPaymentMapper xs2aPisCommonPaymentMapper;
    private final Xs2aToCmsPisCommonPaymentRequestMapper xs2aToCmsPisCommonPaymentRequestMapper;
    private final S paymentInitiationService;
    private final RequestProviderService requestProviderService;

    @Override
    public ResponseObject<PaymentInitiationResponse> createPayment(byte[] payment, PaymentInitiationParameters paymentInitiationParameters, TppInfo tppInfo) {
        PsuIdData psuData = paymentInitiationParameters.getPsuData();
        P paymentRequest = this.getPaymentRequest(payment, paymentInitiationParameters);
        OffsetDateTime creationTimestamp = OffsetDateTime.now();
        ((CommonPayment)paymentRequest).setCreationTimestamp(creationTimestamp);
        ((CommonPayment)paymentRequest).setInstanceId(paymentInitiationParameters.getInstanceId());
        PaymentInitiationResponse response = this.paymentInitiationService.initiatePayment(paymentRequest, paymentInitiationParameters.getPaymentProduct(), psuData);
        if (response.hasError()) {
            return this.buildErrorResponse(response.getErrorHolder());
        }
        String internalRequestId = this.requestProviderService.getInternalRequestIdString();
        String contentType = this.requestProviderService.getContentTypeHeader();
        PisPaymentInfo pisPaymentInfo = this.xs2aToCmsPisCommonPaymentRequestMapper.mapToPisPaymentInfo(new PisPaymentInfoCreationObject(paymentInitiationParameters, tppInfo, response, ((CommonPayment)paymentRequest).getPaymentData(), internalRequestId, creationTimestamp, contentType));
        response.setInternalRequestId(internalRequestId);
        CreatePisCommonPaymentResponse cmsResponse = this.pisCommonPaymentService.createCommonPayment(pisPaymentInfo);
        response.setTppNotificationContentPreferred(cmsResponse.getTppNotificationContentPreferred());
        Xs2aPisCommonPayment pisCommonPayment = this.xs2aPisCommonPaymentMapper.mapToXs2aPisCommonPayment(cmsResponse, psuData);
        String externalPaymentId = pisCommonPayment.getPaymentId();
        if (StringUtils.isBlank((CharSequence)externalPaymentId)) {
            return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PAYMENT_FAILED)).build();
        }
        InitialSpiAspspConsentDataProvider aspspConsentDataProvider = response.getAspspConsentDataProvider();
        aspspConsentDataProvider.saveWith(externalPaymentId);
        response.setPaymentId(externalPaymentId);
        boolean implicitMethod = this.authorisationMethodDecider.isImplicitMethod(paymentInitiationParameters.isTppExplicitAuthorisationPreferred(), response.isMultilevelScaRequired());
        if (implicitMethod) {
            PisScaAuthorisationService pisScaAuthorisationService = (PisScaAuthorisationService)this.pisScaAuthorisationServiceResolver.getService();
            Optional<Xs2aCreatePisAuthorisationResponse> consentAuthorisation = pisScaAuthorisationService.createCommonPaymentAuthorisation(externalPaymentId, ((CommonPayment)paymentRequest).getPaymentType(), paymentInitiationParameters.getPsuData());
            if (!consentAuthorisation.isPresent()) {
                return ResponseObject.builder().fail(ErrorType.PIS_400, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.PAYMENT_FAILED)).build();
            }
            Xs2aCreatePisAuthorisationResponse authorisationResponse = consentAuthorisation.get();
            response.setAuthorizationId(authorisationResponse.getAuthorisationId());
            response.setScaStatus(authorisationResponse.getScaStatus());
        }
        return ResponseObject.builder().body(response).build();
    }

    protected abstract P getPaymentRequest(byte[] var1, PaymentInitiationParameters var2);

    @ConstructorProperties(value={"pisCommonPaymentService", "pisScaAuthorisationServiceResolver", "authorisationMethodDecider", "xs2aPisCommonPaymentMapper", "xs2aToCmsPisCommonPaymentRequestMapper", "paymentInitiationService", "requestProviderService"})
    public AbstractCreatePaymentService(Xs2aPisCommonPaymentService pisCommonPaymentService, PisScaAuthorisationServiceResolver pisScaAuthorisationServiceResolver, AuthorisationMethodDecider authorisationMethodDecider, Xs2aPisCommonPaymentMapper xs2aPisCommonPaymentMapper, Xs2aToCmsPisCommonPaymentRequestMapper xs2aToCmsPisCommonPaymentRequestMapper, S paymentInitiationService, RequestProviderService requestProviderService) {
        this.pisCommonPaymentService = pisCommonPaymentService;
        this.pisScaAuthorisationServiceResolver = pisScaAuthorisationServiceResolver;
        this.authorisationMethodDecider = authorisationMethodDecider;
        this.xs2aPisCommonPaymentMapper = xs2aPisCommonPaymentMapper;
        this.xs2aToCmsPisCommonPaymentRequestMapper = xs2aToCmsPisCommonPaymentRequestMapper;
        this.paymentInitiationService = paymentInitiationService;
        this.requestProviderService = requestProviderService;
    }
}

