/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.consent;

import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppNotificationData;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationResponse;
import de.adorsys.psd2.xs2a.service.payment.create.PisPaymentInfoCreationObject;
import java.util.Collections;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class Xs2aToCmsPisCommonPaymentRequestMapper {
    public PisPaymentInfo mapToPisPaymentInfo(PisPaymentInfoCreationObject creationObject) {
        PaymentInitiationParameters paymentInitiationParameters = creationObject.getPaymentInitiationParameters();
        PaymentInitiationResponse response = creationObject.getResponse();
        PisPaymentInfo paymentInfo = new PisPaymentInfo();
        paymentInfo.setPaymentProduct(paymentInitiationParameters.getPaymentProduct());
        paymentInfo.setPaymentType(paymentInitiationParameters.getPaymentType());
        paymentInfo.setTransactionStatus(response.getTransactionStatus());
        paymentInfo.setTppInfo(creationObject.getTppInfo());
        paymentInfo.setPaymentId(response.getPaymentId());
        paymentInfo.setPsuDataList(Collections.singletonList(paymentInitiationParameters.getPsuData()));
        paymentInfo.setMultilevelScaRequired(response.isMultilevelScaRequired());
        paymentInfo.setAspspAccountId(response.getAspspAccountId());
        paymentInfo.setTppRedirectUri(paymentInitiationParameters.getTppRedirectUri());
        paymentInfo.setInternalRequestId(creationObject.getInternalRequestId());
        paymentInfo.setPaymentData(creationObject.getPaymentData());
        paymentInfo.setCreationTimestamp(creationObject.getCreationTimestamp());
        paymentInfo.setTppNotificationUri((String)Optional.ofNullable(paymentInitiationParameters.getTppNotificationData()).map(TppNotificationData::getTppNotificationUri).orElse(null));
        paymentInfo.setNotificationSupportedModes(Optional.ofNullable(paymentInitiationParameters.getTppNotificationData()).map(TppNotificationData::getNotificationModes).orElse(Collections.emptyList()));
        paymentInfo.setContentType(creationObject.getContentType());
        paymentInfo.setTppBrandLoggingInformation(paymentInitiationParameters.getTppBrandLoggingInformation());
        paymentInfo.setInstanceId(paymentInitiationParameters.getInstanceId());
        return paymentInfo;
    }
}

