/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.TrustedBeneficiaries;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTrustedBeneficiaries;
import de.adorsys.psd2.xs2a.service.mapper.TrustedBeneficiariesModelMapper;
import de.adorsys.psd2.xs2a.web.mapper.Xs2aAddressMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TrustedBeneficiariesModelMapperImpl
extends TrustedBeneficiariesModelMapper {
    @Autowired
    private Xs2aAddressMapper xs2aAddressMapper;

    @Override
    public TrustedBeneficiaries mapToTrustedBeneficiaries(Xs2aTrustedBeneficiaries trustedBeneficiaries) {
        if (trustedBeneficiaries == null) {
            return null;
        }
        TrustedBeneficiaries trustedBeneficiaries1 = new TrustedBeneficiaries();
        trustedBeneficiaries1.setTrustedBeneficiaryId(trustedBeneficiaries.getTrustedBeneficiaryId());
        trustedBeneficiaries1.setDebtorAccount(this.accountReferenceToAccountReference(trustedBeneficiaries.getDebtorAccount()));
        trustedBeneficiaries1.setCreditorAccount(this.accountReferenceToAccountReference(trustedBeneficiaries.getCreditorAccount()));
        trustedBeneficiaries1.setCreditorAgent(trustedBeneficiaries.getCreditorAgent());
        trustedBeneficiaries1.setCreditorName(trustedBeneficiaries.getCreditorName());
        trustedBeneficiaries1.setCreditorAlias(trustedBeneficiaries.getCreditorAlias());
        trustedBeneficiaries1.setCreditorId(trustedBeneficiaries.getCreditorId());
        trustedBeneficiaries1.setCreditorAddress(this.xs2aAddressMapper.mapToAddress(trustedBeneficiaries.getCreditorAddress()));
        return trustedBeneficiaries1;
    }

    protected AccountReference accountReferenceToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference) {
        if (accountReference == null) {
            return null;
        }
        AccountReference accountReference1 = new AccountReference();
        accountReference1.setIban(accountReference.getIban());
        accountReference1.setBban(accountReference.getBban());
        accountReference1.setPan(accountReference.getPan());
        accountReference1.setMaskedPan(accountReference.getMaskedPan());
        accountReference1.setMsisdn(accountReference.getMsisdn());
        if (accountReference.getCurrency() != null) {
            accountReference1.setCurrency(accountReference.getCurrency().getCurrencyCode());
        }
        return accountReference1;
    }
}

