/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.ActionStatus;
import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationResponse;
import de.adorsys.psd2.consent.api.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.consent.api.consent.CmsCreateConsentResponse;
import de.adorsys.psd2.consent.api.service.AisConsentServiceEncrypted;
import de.adorsys.psd2.consent.api.service.ConsentServiceEncrypted;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.logger.context.LoggingContextService;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCreateAisConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.ScaApproachResolver;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentAuthorisationMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.profile.FrequencyPerDateCalculationService;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Xs2aAisConsentService {
    private static final Logger log = LoggerFactory.getLogger(Xs2aAisConsentService.class);
    private final ConsentServiceEncrypted consentService;
    private final AisConsentServiceEncrypted aisConsentService;
    private final Xs2aAuthorisationService authorisationService;
    private final Xs2aAisConsentMapper aisConsentMapper;
    private final Xs2aAisConsentAuthorisationMapper aisConsentAuthorisationMapper;
    private final FrequencyPerDateCalculationService frequencyPerDateCalculationService;
    private final ScaApproachResolver scaApproachResolver;
    private final RequestProviderService requestProviderService;
    private final LoggingContextService loggingContextService;

    public Optional<Xs2aCreateAisConsentResponse> createConsent(CreateConsentReq request, PsuIdData psuData, TppInfo tppInfo) {
        CmsResponse response;
        int allowedFrequencyPerDay = this.frequencyPerDateCalculationService.getMinFrequencyPerDay(request.getFrequencyPerDay());
        CmsConsent cmsConsent = this.aisConsentMapper.mapToCmsConsent(request, psuData, tppInfo, allowedFrequencyPerDay);
        try {
            response = this.consentService.createConsent(cmsConsent);
        }
        catch (WrongChecksumException e) {
            log.info("Consent cannot be created, checksum verification failed");
            return Optional.empty();
        }
        if (response.hasError()) {
            log.info("Consent cannot be created, because can't save to cms DB");
            return Optional.empty();
        }
        CmsCreateConsentResponse createConsentResponse = (CmsCreateConsentResponse)response.getPayload();
        return Optional.of(new Xs2aCreateAisConsentResponse(createConsentResponse.getConsentId(), this.aisConsentMapper.mapToAisConsent(createConsentResponse.getCmsConsent()), createConsentResponse.getCmsConsent().getTppInformation().getTppNotificationSupportedModes()));
    }

    public Optional<AisConsent> getAccountConsentById(String consentId) {
        CmsResponse consentById = this.consentService.getConsentById(consentId);
        if (consentById.hasError()) {
            log.info("Get consent by id failed due to CMS problems");
            return Optional.empty();
        }
        return Optional.ofNullable(this.aisConsentMapper.mapToAisConsent((CmsConsent)consentById.getPayload()));
    }

    public boolean findAndTerminateOldConsentsByNewConsentId(String newConsentId) {
        CmsResponse response = this.consentService.findAndTerminateOldConsentsByNewConsentId(newConsentId);
        return response.isSuccessful() && (Boolean)response.getPayload() != false;
    }

    public void updateConsentStatus(String consentId, ConsentStatus consentStatus) {
        CmsResponse statusUpdated;
        try {
            statusUpdated = this.consentService.updateConsentStatusById(consentId, consentStatus);
        }
        catch (WrongChecksumException e) {
            log.info("updateConsentStatus cannot be executed, checksum verification failed");
            return;
        }
        if (statusUpdated.isSuccessful() && BooleanUtils.isTrue((Boolean)((Boolean)statusUpdated.getPayload()))) {
            this.loggingContextService.storeConsentStatus(consentStatus);
        }
    }

    public void consentActionLog(String tppId, String consentId, ActionStatus actionStatus, String requestUri, boolean updateUsage, String resourceId, String transactionId) {
        try {
            this.aisConsentService.checkConsentAndSaveActionLog(new AisConsentActionRequest(tppId, consentId, actionStatus, requestUri, updateUsage, resourceId, transactionId));
        }
        catch (WrongChecksumException e) {
            log.info("consentActionLog cannot be executed, checksum verification failed");
        }
    }

    public Optional<CreateAuthorisationResponse> createAisConsentAuthorisation(String consentId, ScaStatus scaStatus, PsuIdData psuData) {
        String tppRedirectURI = this.requestProviderService.getTppRedirectURI();
        String tppNOKRedirectURI = this.requestProviderService.getTppNokRedirectURI();
        CreateAuthorisationRequest request = this.aisConsentAuthorisationMapper.mapToAuthorisationRequest(scaStatus, psuData, this.scaApproachResolver.resolveScaApproach(), tppRedirectURI, tppNOKRedirectURI);
        return this.authorisationService.createAuthorisation(request, consentId, AuthorisationType.AIS);
    }

    public void updateConsentAuthorisation(UpdateConsentPsuDataReq updatePsuData) {
        Optional.ofNullable(updatePsuData).ifPresent(req -> {
            UpdateAuthorisationRequest request = this.aisConsentAuthorisationMapper.mapToAuthorisationRequest((UpdateConsentPsuDataReq)req);
            this.authorisationService.updateAuthorisation(request, req.getAuthorizationId());
        });
    }

    public CmsResponse<AisConsent> updateAspspAccountAccess(String consentId, AccountAccess accountAccess) {
        CmsResponse response;
        CmsResponse.CmsResponseBuilder builder = CmsResponse.builder();
        try {
            response = this.aisConsentService.updateAspspAccountAccess(consentId, accountAccess);
        }
        catch (WrongChecksumException e) {
            return builder.error(CmsError.CHECKSUM_ERROR).build();
        }
        if (response.hasError()) {
            return builder.error(response.getError()).build();
        }
        return builder.payload((Object)this.aisConsentMapper.mapToAisConsent((CmsConsent)response.getPayload())).build();
    }

    public Optional<List<String>> getAuthorisationSubResources(String consentId) {
        return this.authorisationService.getAuthorisationSubResources(consentId, AuthorisationType.AIS);
    }

    public Optional<ScaStatus> getAuthorisationScaStatus(String consentId, String authorisationId) {
        return this.authorisationService.getAuthorisationScaStatus(authorisationId, consentId, AuthorisationType.AIS);
    }

    public void updateMultilevelScaRequired(String consentId, boolean multilevelScaRequired) {
        try {
            this.consentService.updateMultilevelScaRequired(consentId, multilevelScaRequired);
        }
        catch (WrongChecksumException e) {
            log.info("updateMultilevelScaRequired cannot be executed, checksum verification failed");
        }
    }

    @ConstructorProperties(value={"consentService", "aisConsentService", "authorisationService", "aisConsentMapper", "aisConsentAuthorisationMapper", "frequencyPerDateCalculationService", "scaApproachResolver", "requestProviderService", "loggingContextService"})
    public Xs2aAisConsentService(ConsentServiceEncrypted consentService, AisConsentServiceEncrypted aisConsentService, Xs2aAuthorisationService authorisationService, Xs2aAisConsentMapper aisConsentMapper, Xs2aAisConsentAuthorisationMapper aisConsentAuthorisationMapper, FrequencyPerDateCalculationService frequencyPerDateCalculationService, ScaApproachResolver scaApproachResolver, RequestProviderService requestProviderService, LoggingContextService loggingContextService) {
        this.consentService = consentService;
        this.aisConsentService = aisConsentService;
        this.authorisationService = authorisationService;
        this.aisConsentMapper = aisConsentMapper;
        this.aisConsentAuthorisationMapper = aisConsentAuthorisationMapper;
        this.frequencyPerDateCalculationService = frequencyPerDateCalculationService;
        this.scaApproachResolver = scaApproachResolver;
        this.requestProviderService = requestProviderService;
        this.loggingContextService = loggingContextService;
    }
}

