/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.ais;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.AuthorisationServiceEncrypted;
import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.authorization.Xs2aAuthorisationService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiCheckConfirmationCodeRequest;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiConsentConfirmationCodeValidationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AisAuthorisationConfirmationService {
    private static final Logger log = LoggerFactory.getLogger(AisAuthorisationConfirmationService.class);
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;
    private final SpiContextDataProvider spiContextDataProvider;
    private final SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory;
    private final Xs2aAuthorisationService authorisationService;
    private final Xs2aAisConsentService aisConsentService;
    private final AisConsentSpi aisConsentSpi;
    private final Xs2aAisConsentMapper aisConsentMapper;
    private final SpiErrorMapper spiErrorMapper;
    private final AuthorisationServiceEncrypted authorisationServiceEncrypted;

    public ResponseObject<UpdateConsentPsuDataResponse> processAuthorisationConfirmation(UpdateConsentPsuDataReq request) {
        String authorisationId = request.getAuthorisationId();
        CmsResponse authorisationCmsResponse = this.authorisationServiceEncrypted.getAuthorisationById(authorisationId);
        if (authorisationCmsResponse.hasError()) {
            log.info("Authorisation-ID: [{}]. Update consent PSU data failed: authorisation not found by ID", (Object)request.getAuthorizationId());
            return ResponseObject.builder().fail(ErrorType.AIS_403, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)).build();
        }
        Authorisation authorisation = (Authorisation)authorisationCmsResponse.getPayload();
        ScaStatus currentStatus = authorisation.getScaStatus();
        boolean processIsAllowed = currentStatus == ScaStatus.UNCONFIRMED;
        UpdateConsentPsuDataResponse response = processIsAllowed ? this.processAuthorisationConfirmationInternal(request, authorisation.getScaAuthenticationData()) : this.buildScaConfirmationCodeErrorResponse(request.getConsentId(), authorisationId, request.getPsuData());
        return Optional.ofNullable(response.getErrorHolder()).map(e -> ResponseObject.builder().fail((ErrorHolder)e).build()).orElseGet(ResponseObject.builder().body(response)::build);
    }

    private UpdateConsentPsuDataResponse processAuthorisationConfirmationInternal(UpdateConsentPsuDataReq request, String confirmationCodeFromDb) {
        return this.aspspProfileServiceWrapper.isAuthorisationConfirmationCheckByXs2a() ? this.checkAuthorisationConfirmationXs2a(request, confirmationCodeFromDb) : this.checkAuthorisationConfirmationOnSpi(request);
    }

    private UpdateConsentPsuDataResponse checkAuthorisationConfirmationXs2a(UpdateConsentPsuDataReq request, String confirmationCodeFromDb) {
        UpdateConsentPsuDataResponse response;
        String consentId = request.getConsentId();
        String authorisationId = request.getAuthorisationId();
        Optional<AisConsent> aisConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        PsuIdData psuData = request.getPsuData();
        if (aisConsentOptional.isEmpty()) {
            return this.buildConsentNotFoundErrorResponse(consentId, authorisationId, psuData);
        }
        SpiContextData contextData = this.spiContextDataProvider.provideWithPsuIdData(psuData);
        SpiAccountConsent spiAccountConsent = this.aisConsentMapper.mapToSpiAccountConsent(aisConsentOptional.get());
        SpiAspspConsentDataProvider aspspDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId);
        boolean codeCorrect = StringUtils.equals((CharSequence)request.getConfirmationCode(), (CharSequence)confirmationCodeFromDb);
        SpiResponse spiResponse = this.aisConsentSpi.notifyConfirmationCodeValidation(contextData, codeCorrect, spiAccountConsent, aspspDataProvider);
        if (spiResponse.hasError()) {
            return this.buildConfirmationCodeSpiErrorResponse((SpiResponse<SpiConsentConfirmationCodeValidationResponse>)spiResponse, consentId, authorisationId, psuData);
        }
        SpiConsentConfirmationCodeValidationResponse confirmationCodeValidationResponse = (SpiConsentConfirmationCodeValidationResponse)spiResponse.getPayload();
        UpdateConsentPsuDataResponse updateConsentPsuDataResponse = response = codeCorrect ? new UpdateConsentPsuDataResponse(confirmationCodeValidationResponse.getScaStatus(), consentId, authorisationId, psuData) : this.buildScaConfirmationCodeErrorResponse(consentId, authorisationId, psuData);
        if (spiResponse.isSuccessful()) {
            SpiConsentConfirmationCodeValidationResponse payload = (SpiConsentConfirmationCodeValidationResponse)spiResponse.getPayload();
            this.authorisationService.updateAuthorisationStatus(authorisationId, payload.getScaStatus());
            this.aisConsentService.updateConsentStatus(consentId, payload.getConsentStatus());
        }
        return response;
    }

    private UpdateConsentPsuDataResponse checkAuthorisationConfirmationOnSpi(UpdateConsentPsuDataReq request) {
        UpdateConsentPsuDataResponse updateConsentPsuDataResponse;
        SpiAspspConsentDataProvider aspspDataProvider;
        SpiCheckConfirmationCodeRequest spiCheckConfirmationCodeRequest;
        String consentId = request.getConsentId();
        String authorisationId = request.getAuthorisationId();
        Optional<AisConsent> aisConsentOptional = this.aisConsentService.getAccountConsentById(consentId);
        if (aisConsentOptional.isEmpty()) {
            return this.buildConsentNotFoundErrorResponse(consentId, authorisationId, request.getPsuData());
        }
        SpiContextData contextData = this.spiContextDataProvider.provideWithPsuIdData(request.getPsuData());
        SpiResponse spiResponse = this.aisConsentSpi.checkConfirmationCode(contextData, spiCheckConfirmationCodeRequest = new SpiCheckConfirmationCodeRequest(request.getConfirmationCode(), authorisationId), aspspDataProvider = this.aspspConsentDataProviderFactory.getSpiAspspDataProviderFor(consentId));
        if (spiResponse.hasError()) {
            this.aisConsentService.updateConsentStatus(consentId, ConsentStatus.REJECTED);
            updateConsentPsuDataResponse = this.buildConfirmationCodeSpiErrorResponse((SpiResponse<SpiConsentConfirmationCodeValidationResponse>)spiResponse, consentId, authorisationId, request.getPsuData());
        } else {
            SpiConsentConfirmationCodeValidationResponse confirmationCodeValidationResponse = (SpiConsentConfirmationCodeValidationResponse)spiResponse.getPayload();
            this.aisConsentService.updateConsentStatus(consentId, confirmationCodeValidationResponse.getConsentStatus());
            updateConsentPsuDataResponse = new UpdateConsentPsuDataResponse(confirmationCodeValidationResponse.getScaStatus(), consentId, authorisationId, request.getPsuData());
        }
        this.authorisationService.updateAuthorisationStatus(authorisationId, updateConsentPsuDataResponse.getScaStatus());
        return updateConsentPsuDataResponse;
    }

    private UpdateConsentPsuDataResponse buildScaConfirmationCodeErrorResponse(String consentId, String authorisationId, PsuIdData psuIdData) {
        ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)ErrorType.AIS_400).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.SCA_INVALID)}).build();
        log.info("Authorisation-ID: [{}]. Update consent PSU data failed: confirmation code is wrong or has been provided more than once.", (Object)authorisationId);
        return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuIdData);
    }

    private UpdateConsentPsuDataResponse buildConfirmationCodeSpiErrorResponse(SpiResponse<SpiConsentConfirmationCodeValidationResponse> spiResponse, String consentId, String authorisationId, PsuIdData psuIdData) {
        ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse, ServiceType.AIS);
        log.info("Authorisation-ID: [{}]. Update consent PSU data failed: error occurred at SPI.", (Object)authorisationId);
        return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuIdData);
    }

    private UpdateConsentPsuDataResponse buildConsentNotFoundErrorResponse(String consentId, String authorisationId, PsuIdData psuIdData) {
        ErrorHolder errorHolder = ErrorHolder.builder((ErrorType)ErrorType.AIS_403).tppMessages(new TppMessageInformation[]{TppMessageInformation.of((MessageErrorCode)MessageErrorCode.CONSENT_UNKNOWN_403)}).build();
        log.info("Consent-ID: [{}]. Update consent PSU data failed: consent not found by id", (Object)consentId);
        return new UpdateConsentPsuDataResponse(errorHolder, consentId, authorisationId, psuIdData);
    }

    @ConstructorProperties(value={"aspspProfileServiceWrapper", "spiContextDataProvider", "aspspConsentDataProviderFactory", "authorisationService", "aisConsentService", "aisConsentSpi", "aisConsentMapper", "spiErrorMapper", "authorisationServiceEncrypted"})
    public AisAuthorisationConfirmationService(AspspProfileServiceWrapper aspspProfileServiceWrapper, SpiContextDataProvider spiContextDataProvider, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, Xs2aAuthorisationService authorisationService, Xs2aAisConsentService aisConsentService, AisConsentSpi aisConsentSpi, Xs2aAisConsentMapper aisConsentMapper, SpiErrorMapper spiErrorMapper, AuthorisationServiceEncrypted authorisationServiceEncrypted) {
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
        this.spiContextDataProvider = spiContextDataProvider;
        this.aspspConsentDataProviderFactory = aspspConsentDataProviderFactory;
        this.authorisationService = authorisationService;
        this.aisConsentService = aisConsentService;
        this.aisConsentSpi = aisConsentSpi;
        this.aisConsentMapper = aisConsentMapper;
        this.spiErrorMapper = spiErrorMapper;
        this.authorisationServiceEncrypted = authorisationServiceEncrypted;
    }
}

