/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization;

import de.adorsys.psd2.xs2a.service.authorization.processor.AuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.ExemptedAuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.FailedAuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.FinalisedAuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.PsuAuthenticatedAuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.PsuIdentifiedAuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.ReceivedAuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.ScaMethodSelectedAuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.StartedAuthorisationProcessor;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorRequest;
import de.adorsys.psd2.xs2a.service.authorization.processor.model.AuthorisationProcessorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class AuthorisationChainResponsibilityService {
    private static final Logger log = LoggerFactory.getLogger(AuthorisationChainResponsibilityService.class);
    private AuthorisationProcessor receivedAuthorisationProcessor;
    private ApplicationContext applicationContext;

    @Autowired
    public AuthorisationChainResponsibilityService(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.initAuthorisationChains();
    }

    public AuthorisationProcessorResponse apply(AuthorisationProcessorRequest request) {
        return this.receivedAuthorisationProcessor.apply(request);
    }

    private void initAuthorisationChains() {
        this.receivedAuthorisationProcessor = new ReceivedAuthorisationProcessor(this.applicationContext);
        PsuIdentifiedAuthorisationProcessor psuIdentifiedAuthorisationProcessor = new PsuIdentifiedAuthorisationProcessor(this.applicationContext);
        PsuAuthenticatedAuthorisationProcessor psuAuthenticatedAuthorisationProcessor = new PsuAuthenticatedAuthorisationProcessor(this.applicationContext);
        ScaMethodSelectedAuthorisationProcessor scaMethodSelectedAuthorisationProcessor = new ScaMethodSelectedAuthorisationProcessor(this.applicationContext);
        StartedAuthorisationProcessor startedAuthorisationProcessor = new StartedAuthorisationProcessor(this.applicationContext);
        FinalisedAuthorisationProcessor finalisedAuthorisationProcessor = new FinalisedAuthorisationProcessor(this.applicationContext);
        FailedAuthorisationProcessor failedAuthorisationProcessor = new FailedAuthorisationProcessor(this.applicationContext);
        ExemptedAuthorisationProcessor exemptedAuthorisationProcessor = new ExemptedAuthorisationProcessor(this.applicationContext);
        this.receivedAuthorisationProcessor.setNext(psuIdentifiedAuthorisationProcessor);
        psuIdentifiedAuthorisationProcessor.setNext(psuAuthenticatedAuthorisationProcessor);
        psuAuthenticatedAuthorisationProcessor.setNext(scaMethodSelectedAuthorisationProcessor);
        scaMethodSelectedAuthorisationProcessor.setNext(startedAuthorisationProcessor);
        startedAuthorisationProcessor.setNext(finalisedAuthorisationProcessor);
        finalisedAuthorisationProcessor.setNext(failedAuthorisationProcessor);
        failedAuthorisationProcessor.setNext(exemptedAuthorisationProcessor);
    }
}

