package de.adorsys.psd2.xs2a.service.mapper.consent;

import de.adorsys.psd2.consent.api.ais.CmsConsent;
import de.adorsys.psd2.core.data.piis.v1.PiisConsent;
import de.adorsys.psd2.core.mapper.ConsentDataMapper;
import de.adorsys.psd2.xs2a.core.authorisation.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-05-19T13:41:08+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.2 (Oracle Corporation)"
)
@Component
public class Xs2aPiisConsentMapperImpl implements Xs2aPiisConsentMapper {

    @Autowired
    private ConsentDataMapper consentDataMapper;

    @Override
    public PiisConsent mapToPiisConsent(CmsConsent cmsConsent) {
        if ( cmsConsent == null ) {
            return null;
        }

        PiisConsent piisConsent = new PiisConsent();

        piisConsent.setConsentTppInformation( cmsConsent.getTppInformation() );
        piisConsent.setConsentData( consentDataMapper.mapToPiisConsentData( cmsConsent.getConsentData() ) );
        piisConsent.setId( cmsConsent.getId() );
        piisConsent.setInternalRequestId( cmsConsent.getInternalRequestId() );
        piisConsent.setConsentStatus( cmsConsent.getConsentStatus() );
        piisConsent.setFrequencyPerDay( cmsConsent.getFrequencyPerDay() );
        piisConsent.setRecurringIndicator( cmsConsent.isRecurringIndicator() );
        piisConsent.setMultilevelScaRequired( cmsConsent.isMultilevelScaRequired() );
        piisConsent.setValidUntil( cmsConsent.getValidUntil() );
        piisConsent.setExpireDate( cmsConsent.getExpireDate() );
        piisConsent.setLastActionDate( cmsConsent.getLastActionDate() );
        piisConsent.setCreationTimestamp( cmsConsent.getCreationTimestamp() );
        piisConsent.setStatusChangeTimestamp( cmsConsent.getStatusChangeTimestamp() );
        piisConsent.setAuthorisationTemplate( cmsConsent.getAuthorisationTemplate() );
        List<PsuIdData> list = cmsConsent.getPsuIdDataList();
        if ( list != null ) {
            piisConsent.setPsuIdDataList( new ArrayList<PsuIdData>( list ) );
        }
        piisConsent.setAuthorisations( authorisationListToAccountConsentAuthorizationList( cmsConsent.getAuthorisations() ) );
        Map<String, Integer> map = cmsConsent.getUsages();
        if ( map != null ) {
            piisConsent.setUsages( new HashMap<String, Integer>( map ) );
        }
        piisConsent.setTppAccountAccesses( cmsConsent.getTppAccountAccesses() );
        piisConsent.setAspspAccountAccesses( cmsConsent.getAspspAccountAccesses() );

        return piisConsent;
    }

    protected AccountConsentAuthorization authorisationToAccountConsentAuthorization(Authorisation authorisation) {
        if ( authorisation == null ) {
            return null;
        }

        AccountConsentAuthorization accountConsentAuthorization = new AccountConsentAuthorization();

        accountConsentAuthorization.setPsuIdData( authorisation.getPsuIdData() );
        accountConsentAuthorization.setScaStatus( authorisation.getScaStatus() );
        accountConsentAuthorization.setPassword( authorisation.getPassword() );
        accountConsentAuthorization.setChosenScaApproach( authorisation.getChosenScaApproach() );
        accountConsentAuthorization.setAuthenticationMethodId( authorisation.getAuthenticationMethodId() );
        accountConsentAuthorization.setScaAuthenticationData( authorisation.getScaAuthenticationData() );

        return accountConsentAuthorization;
    }

    protected List<AccountConsentAuthorization> authorisationListToAccountConsentAuthorizationList(List<Authorisation> list) {
        if ( list == null ) {
            return null;
        }

        List<AccountConsentAuthorization> list1 = new ArrayList<AccountConsentAuthorization>( list.size() );
        for ( Authorisation authorisation : list ) {
            list1.add( authorisationToAccountConsentAuthorization( authorisation ) );
        }

        return list1;
    }
}
