/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.aspect;

import de.adorsys.psd2.core.data.ais.AisConsent;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountDetailsHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountListHolder;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aCardTransactionsReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReportByPeriodRequest;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.web.aspect.AbstractLinkAspect;
import de.adorsys.psd2.xs2a.web.controller.CardAccountController;
import de.adorsys.psd2.xs2a.web.link.CardAccountDetailsLinks;
import de.adorsys.psd2.xs2a.web.link.TransactionsReportCardDownloadLinks;
import de.adorsys.psd2.xs2a.web.link.TransactionsReportCardLinks;
import java.util.List;
import java.util.Optional;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CardAccountAspect
extends AbstractLinkAspect<CardAccountController> {
    public CardAccountAspect(AspspProfileServiceWrapper aspspProfileServiceWrapper) {
        super(aspspProfileServiceWrapper);
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.ais.CardAccountService.getCardAccountList(..))", returning="result")
    public ResponseObject<Xs2aCardAccountListHolder> getCardAccountList(ResponseObject<Xs2aCardAccountListHolder> result) {
        if (!result.hasError()) {
            Xs2aCardAccountListHolder body = result.getBody();
            List<Xs2aCardAccountDetails> cardAccountDetails = body.getCardAccountDetails();
            AisConsent aisConsent = body.getAisConsent();
            if (aisConsent.getAisConsentRequestType() == AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS) {
                cardAccountDetails.forEach(acc -> acc.setLinks(null));
            } else {
                cardAccountDetails.forEach(acc -> this.setLinksForCardAccountDetails((Xs2aCardAccountDetails)acc, body.getAisConsent()));
            }
        }
        return result;
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.ais.CardAccountService.getCardAccountDetails(..))", returning="result")
    public ResponseObject<Xs2aCardAccountDetailsHolder> getCardAccountDetails(ResponseObject<Xs2aCardAccountDetailsHolder> result) {
        if (!result.hasError()) {
            Xs2aCardAccountDetailsHolder body = result.getBody();
            this.setLinksForCardAccountDetails(body.getCardAccountDetails(), body.getAisConsent());
        }
        return result;
    }

    @AfterReturning(pointcut="execution(* de.adorsys.psd2.xs2a.service.ais.CardTransactionService.getCardTransactionsReportByPeriod(..)) && args(request)", returning="result", argNames="result,request")
    public ResponseObject<Xs2aCardTransactionsReport> getTransactionsReportByPeriod(ResponseObject<Xs2aCardTransactionsReport> result, Xs2aTransactionsReportByPeriodRequest request) {
        if (!result.hasError()) {
            Xs2aCardTransactionsReport transactionsReport = result.getBody();
            boolean isWithBalance = Optional.ofNullable(transactionsReport.getBalances()).map(balances -> !balances.isEmpty()).orElse(false);
            transactionsReport.setLinks(new TransactionsReportCardDownloadLinks(this.getHttpUrl(), request.getAccountId(), isWithBalance, transactionsReport.getDownloadId()));
            Xs2aCardAccountReport cardAccountReport = transactionsReport.getCardAccountReport();
            if (cardAccountReport != null) {
                cardAccountReport.setLinks(new TransactionsReportCardLinks(this.getHttpUrl(), request.getAccountId(), isWithBalance));
            }
        }
        return result;
    }

    private void setLinksForCardAccountDetails(Xs2aCardAccountDetails cardAccountDetails, AisConsent aisConsent) {
        String url = this.getHttpUrl();
        String id = cardAccountDetails.getResourceId();
        CardAccountDetailsLinks cardAccountDetailsLinks = new CardAccountDetailsLinks(url, id, aisConsent);
        cardAccountDetails.setLinks(cardAccountDetailsLinks);
    }
}

