/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.validator.pis.payment;

import de.adorsys.psd2.xs2a.core.error.ErrorType;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import java.beans.ConstructorProperties;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class TransactionStatusAcceptHeaderValidator {
    private final AspspProfileServiceWrapper aspspProfileServiceWrapper;

    public ValidationResult validate(@NotNull String acceptHeader) {
        if (acceptHeader.equalsIgnoreCase("*/*")) {
            return ValidationResult.valid();
        }
        List<String> supportedTransactionStatusFormats = this.aspspProfileServiceWrapper.getSupportedTransactionStatusFormats();
        if (!this.isMediaTypeSupported(acceptHeader, supportedTransactionStatusFormats)) {
            return ValidationResult.invalid(ErrorType.PIS_406, MessageErrorCode.REQUESTED_FORMATS_INVALID);
        }
        return ValidationResult.valid();
    }

    private boolean isMediaTypeSupported(String requestedMediaType, List<String> supportedMediaTypes) {
        return CollectionUtils.isEmpty(supportedMediaTypes) || supportedMediaTypes.stream().anyMatch(s -> StringUtils.containsIgnoreCase((CharSequence)requestedMediaType, (CharSequence)s));
    }

    @ConstructorProperties(value={"aspspProfileServiceWrapper"})
    public TransactionStatusAcceptHeaderValidator(AspspProfileServiceWrapper aspspProfileServiceWrapper) {
        this.aspspProfileServiceWrapper = aspspProfileServiceWrapper;
    }
}

