/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.pis.CreatePisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.consent.api.service.AuthorisationServiceEncrypted;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import de.adorsys.psd2.xs2a.core.authorisation.AuthenticationObject;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAuthenticationObjectToCmsScaMethodMapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Xs2aPisCommonPaymentService {
    private static final Logger log = LoggerFactory.getLogger(Xs2aPisCommonPaymentService.class);
    private final PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted;
    private final AuthorisationServiceEncrypted authorisationServiceEncrypted;
    private final Xs2aAuthenticationObjectToCmsScaMethodMapper xs2AAuthenticationObjectToCmsScaMethodMapper;

    public CreatePisCommonPaymentResponse createCommonPayment(PisPaymentInfo request) {
        CmsResponse response = this.pisCommonPaymentServiceEncrypted.createCommonPayment(request);
        if (response.hasError()) {
            log.info("Payment ID: [{}]. Pis common payment cannot be created, because can't save to cms DB", (Object)request.getPaymentId());
            return null;
        }
        return (CreatePisCommonPaymentResponse)response.getPayload();
    }

    public Optional<PisCommonPaymentResponse> getPisCommonPaymentById(String paymentId) {
        CmsResponse response = this.pisCommonPaymentServiceEncrypted.getCommonPaymentById(paymentId);
        if (response.hasError()) {
            return Optional.empty();
        }
        return Optional.ofNullable((PisCommonPaymentResponse)response.getPayload());
    }

    public boolean updatePisAuthorisationStatus(String authorisationId, ScaStatus scaStatus) {
        CmsResponse response = this.authorisationServiceEncrypted.updateAuthorisationStatus(authorisationId, scaStatus);
        return response.isSuccessful() && (Boolean)response.getPayload() != false;
    }

    public boolean isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        CmsResponse response = this.authorisationServiceEncrypted.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
        return response.isSuccessful() && (Boolean)response.getPayload() != false;
    }

    public boolean saveAuthenticationMethods(String authorisationId, List<AuthenticationObject> methods) {
        CmsResponse response = this.authorisationServiceEncrypted.saveAuthenticationMethods(authorisationId, this.xs2AAuthenticationObjectToCmsScaMethodMapper.mapToCmsScaMethods(methods));
        return response.isSuccessful() && (Boolean)response.getPayload() != false;
    }

    public void updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        this.authorisationServiceEncrypted.updateScaApproach(authorisationId, scaApproach);
    }

    public boolean updateMultilevelSca(String paymentId, boolean multilevelScaRequired) {
        CmsResponse response = this.pisCommonPaymentServiceEncrypted.updateMultilevelSca(paymentId, multilevelScaRequired);
        return response.isSuccessful() && (Boolean)response.getPayload() != false;
    }

    @ConstructorProperties(value={"pisCommonPaymentServiceEncrypted", "authorisationServiceEncrypted", "xs2AAuthenticationObjectToCmsScaMethodMapper"})
    public Xs2aPisCommonPaymentService(PisCommonPaymentServiceEncrypted pisCommonPaymentServiceEncrypted, AuthorisationServiceEncrypted authorisationServiceEncrypted, Xs2aAuthenticationObjectToCmsScaMethodMapper xs2AAuthenticationObjectToCmsScaMethodMapper) {
        this.pisCommonPaymentServiceEncrypted = pisCommonPaymentServiceEncrypted;
        this.authorisationServiceEncrypted = authorisationServiceEncrypted;
        this.xs2AAuthenticationObjectToCmsScaMethodMapper = xs2AAuthenticationObjectToCmsScaMethodMapper;
    }
}

