package de.adorsys.psd2.xs2a.web.mapper;

import de.adorsys.psd2.model.Address;
import de.adorsys.psd2.xs2a.core.domain.address.Xs2aAddress;
import de.adorsys.psd2.xs2a.core.domain.address.Xs2aCountryCode;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-03-26T12:48:05+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.2 (Oracle Corporation)"
)
@Component
public class Xs2aAddressMapperImpl implements Xs2aAddressMapper {

    @Override
    public Xs2aAddress mapToXs2aAddress(Address address) {
        if ( address == null ) {
            return null;
        }

        Xs2aAddress xs2aAddress = new Xs2aAddress();

        xs2aAddress.setCountry( mapToXs2aCountryCode( address ) );
        xs2aAddress.setStreetName( address.getStreetName() );
        xs2aAddress.setBuildingNumber( address.getBuildingNumber() );
        xs2aAddress.setTownName( address.getTownName() );
        xs2aAddress.setPostCode( address.getPostCode() );

        return xs2aAddress;
    }

    @Override
    public Address mapToAddress(Xs2aAddress address) {
        if ( address == null ) {
            return null;
        }

        Address address1 = new Address();

        address1.setCountry( addressCountryCode( address ) );
        address1.setStreetName( address.getStreetName() );
        address1.setBuildingNumber( address.getBuildingNumber() );
        address1.setTownName( address.getTownName() );
        address1.setPostCode( address.getPostCode() );

        return address1;
    }

    private String addressCountryCode(Xs2aAddress xs2aAddress) {
        if ( xs2aAddress == null ) {
            return null;
        }
        Xs2aCountryCode country = xs2aAddress.getCountry();
        if ( country == null ) {
            return null;
        }
        String code = country.getCode();
        if ( code == null ) {
            return null;
        }
        return code;
    }
}
