/*
 * Copyright 2018-2019 adorsys GmbH & Co KG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.adorsys.psd2.xs2a.web.mapper;

import com.fasterxml.jackson.core.type.TypeReference;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.xs2a.domain.HrefType;
import de.adorsys.psd2.xs2a.domain.Links;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
@RequiredArgsConstructor
public class HrefLinkMapper {
    private final Xs2aObjectMapper xs2aObjectMapper;

    /**
     * Maps Links to Links Map
     *
     * @param links Links model Object, where URI links stored as a HrefType
     * @return Map with link name and HrefType value.
     */
    public Map<String, HrefType> mapToLinksMap(Links links) {
        if (links == null) {
            return null;
        }

        return xs2aObjectMapper.convertValue(links, new TypeReference<Map<String, HrefType>>() {
        });
    }
}
