/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator.body;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.web.validator.ErrorBuildingService;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.IBANValidator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class IbanValidator {
    private static final Logger log = LoggerFactory.getLogger(IbanValidator.class);
    @Value(value="${iban.validation.enabled:true}")
    private Boolean ibanValidationEnabled;
    private final ErrorBuildingService errorBuildingService;

    public void validate(String iban, @NotNull MessageError messageError) {
        if (this.ibanValidationEnabled != null && BooleanUtils.isNotTrue((Boolean)this.ibanValidationEnabled)) {
            log.info("IBAN validation is disabled.");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)iban) && !this.isValidIban(iban)) {
            this.errorBuildingService.enrichMessageError(messageError, TppMessageInformation.of((MessageErrorCode)MessageErrorCode.FORMAT_ERROR_INVALID_FIELD, (Object[])new Object[]{"IBAN"}));
        }
    }

    private boolean isValidIban(String iban) {
        IBANValidator validator = IBANValidator.getInstance();
        return validator.isValid(iban);
    }

    @ConstructorProperties(value={"errorBuildingService"})
    public IbanValidator(ErrorBuildingService errorBuildingService) {
        this.errorBuildingService = errorBuildingService;
    }
}

