/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.validator;

import de.adorsys.psd2.xs2a.core.error.MessageError;
import de.adorsys.psd2.xs2a.web.validator.MethodValidator;
import de.adorsys.psd2.xs2a.web.validator.ValidatorWrapper;
import de.adorsys.psd2.xs2a.web.validator.body.BodyValidator;
import de.adorsys.psd2.xs2a.web.validator.header.HeaderValidator;
import de.adorsys.psd2.xs2a.web.validator.path.PathParameterValidator;
import de.adorsys.psd2.xs2a.web.validator.query.QueryParameterValidator;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.servlet.HandlerMapping;

public abstract class AbstractMethodValidator
implements MethodValidator {
    private final ValidatorWrapper validatorWrapper;

    @Override
    public MessageError validate(HttpServletRequest request, MessageError messageError) {
        Map<String, String> headers = Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(h -> h, arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
        TreeMap<String, String> caseInsensitiveHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitiveHeaders.putAll(headers);
        MessageError resultingMessageError = messageError;
        Map<String, List<String>> queryParameters = this.extractQueryParameters(request);
        Map<String, String> pathParameters = this.extractPathParameters(request);
        for (PathParameterValidator pathParameterValidator : this.validatorWrapper.getPathParameterValidators()) {
            resultingMessageError = pathParameterValidator.validate(pathParameters, resultingMessageError);
        }
        for (QueryParameterValidator queryParameterValidator : this.validatorWrapper.getQueryParameterValidators()) {
            resultingMessageError = queryParameterValidator.validate(queryParameters, resultingMessageError);
        }
        for (HeaderValidator headerValidator : this.validatorWrapper.getHeaderValidators()) {
            resultingMessageError = headerValidator.validate(caseInsensitiveHeaders, resultingMessageError);
        }
        for (BodyValidator bodyValidator : this.validatorWrapper.getBodyValidators()) {
            resultingMessageError = bodyValidator.validate(request, resultingMessageError);
        }
        return resultingMessageError;
    }

    private Map<String, String> extractPathParameters(HttpServletRequest request) {
        return (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
    }

    private Map<String, List<String>> extractQueryParameters(HttpServletRequest request) {
        Map requestParameterMap = request.getParameterMap();
        return requestParameterMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Arrays.asList((Object[])e.getValue())));
    }

    @ConstructorProperties(value={"validatorWrapper"})
    protected AbstractMethodValidator(ValidatorWrapper validatorWrapper) {
        this.validatorWrapper = validatorWrapper;
    }

    ValidatorWrapper getValidatorWrapper() {
        return this.validatorWrapper;
    }
}

