/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.web.mapper;

import de.adorsys.psd2.model.StartScaprocessResponse;
import de.adorsys.psd2.model.UpdatePsuAuthenticationResponse;
import de.adorsys.psd2.xs2a.domain.authorisation.AuthorisationResponseType;
import de.adorsys.psd2.xs2a.domain.authorisation.CancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisCancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.xs2a.web.mapper.ChosenScaMethodMapper;
import de.adorsys.psd2.xs2a.web.mapper.CoreObjectsMapper;
import de.adorsys.psd2.xs2a.web.mapper.HrefLinkMapper;
import de.adorsys.psd2.xs2a.web.mapper.ScaMethodsMapper;
import java.util.Objects;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring", uses={CoreObjectsMapper.class, ChosenScaMethodMapper.class, ScaMethodsMapper.class})
public abstract class AuthorisationModelMapper {
    private static final Logger log = LoggerFactory.getLogger(AuthorisationModelMapper.class);
    @Autowired
    protected HrefLinkMapper hrefLinkMapper;
    @Autowired
    protected ScaMethodsMapper scaMethodsMapper;

    public Object mapToStartOrUpdateCancellationResponse(CancellationAuthorisationResponse cancellationAuthorisationResponse) {
        if (Objects.isNull(cancellationAuthorisationResponse)) {
            return null;
        }
        AuthorisationResponseType authorisationResponseType = cancellationAuthorisationResponse.getAuthorisationResponseType();
        if (authorisationResponseType == AuthorisationResponseType.START) {
            return this.mapToStartScaProcessResponseCancellation((Xs2aCreatePisCancellationAuthorisationResponse)cancellationAuthorisationResponse);
        }
        if (authorisationResponseType == AuthorisationResponseType.UPDATE) {
            return this.mapToUpdatePsuAuthenticationResponse((Xs2aUpdatePisCommonPaymentPsuDataResponse)cancellationAuthorisationResponse);
        }
        throw new IllegalArgumentException("Unknown authorisation response type: " + (Object)((Object)authorisationResponseType));
    }

    @Mappings(value={@Mapping(target="_links", ignore=true), @Mapping(target="challengeData", ignore=true), @Mapping(target="chosenScaMethod", ignore=true), @Mapping(target="psuMessage", ignore=true), @Mapping(target="scaMethods", ignore=true), @Mapping(target="links", expression="java(hrefLinkMapper.mapToLinksMap(xs2aResponse.getLinks()))")})
    public abstract StartScaprocessResponse mapToStartScaProcessResponse(Xs2aCreatePisAuthorisationResponse var1);

    @Mappings(value={@Mapping(target="_links", ignore=true), @Mapping(target="challengeData", ignore=true), @Mapping(target="chosenScaMethod", ignore=true), @Mapping(target="scaMethods", ignore=true), @Mapping(target="links", expression="java(hrefLinkMapper.mapToLinksMap(xs2aResponse.getLinks()))")})
    public abstract StartScaprocessResponse mapToStartScaProcessResponse(CreateConsentAuthorizationResponse var1);

    @Mappings(value={@Mapping(target="_links", ignore=true), @Mapping(target="challengeData", ignore=true), @Mapping(target="chosenScaMethod", ignore=true), @Mapping(target="scaMethods", ignore=true), @Mapping(target="links", expression="java(hrefLinkMapper.mapToLinksMap(xs2aResponse.getLinks()))")})
    public abstract StartScaprocessResponse mapToStartScaProcessResponseCancellation(Xs2aCreatePisCancellationAuthorisationResponse var1);

    @Mappings(value={@Mapping(target="_links", ignore=true), @Mapping(target="links", expression="java(hrefLinkMapper.mapToLinksMap(xs2aResponse.getLinks()))"), @Mapping(target="scaMethods", source="availableScaMethods")})
    public abstract UpdatePsuAuthenticationResponse mapToUpdatePsuAuthenticationResponse(Xs2aUpdatePisCommonPaymentPsuDataResponse var1);
}

